/*
 * Decompiled with CFR 0.152.
 */
package phex.statistic;

import java.util.HashMap;
import phex.common.AbstractManager;
import phex.common.bandwidth.BandwidthManager;
import phex.statistic.DailyUptimeStatisticProvider;
import phex.statistic.HorizonStatisticProvider;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticProviderConstants;
import phex.statistic.TransferAverageStatisticProvider;
import phex.statistic.UploadDownloadCountStatistic;
import phex.statistic.UptimeStatisticProvider;

public class StatisticsManager
extends AbstractManager
implements StatisticProviderConstants {
    private HashMap<String, StatisticProvider> statisticProviderMap = new HashMap();

    private StatisticsManager() {
    }

    public void registerStatisticProvider(String name, StatisticProvider provider) {
        this.statisticProviderMap.put(name, provider);
    }

    public StatisticProvider getStatisticProvider(String name) {
        return this.statisticProviderMap.get(name);
    }

    public static StatisticsManager getInstance() {
        return Holder.manager;
    }

    @Override
    public boolean initialize() {
        this.registerStatisticProvider("UptimeProvider", new UptimeStatisticProvider());
        this.registerStatisticProvider("DailyUptimeProvider", new DailyUptimeStatisticProvider());
        return true;
    }

    @Override
    public boolean onPostInitialization() {
        BandwidthManager manager = BandwidthManager.getInstance();
        this.registerStatisticProvider("TotalBandwidthProvider", new TransferAverageStatisticProvider(manager.getPhexBandwidthController()));
        this.registerStatisticProvider("NetworkBandwidthProvider", new TransferAverageStatisticProvider(manager.getNetworkBandwidthController()));
        this.registerStatisticProvider("DownloadBandwidthProvider", new TransferAverageStatisticProvider(manager.getDownloadBandwidthController()));
        this.registerStatisticProvider("UploadBandwidthProvider", new TransferAverageStatisticProvider(manager.getUploadBandwidthController()));
        UploadDownloadCountStatistic.touch();
        this.registerStatisticProvider("HorizonHostCountProvider", HorizonStatisticProvider.HORIZON_HOST_COUNT_PROVIDER);
        this.registerStatisticProvider("HorizonFileCountProvider", HorizonStatisticProvider.HORIZON_FILE_COUNT_PROVIDER);
        this.registerStatisticProvider("HorizonFileSizeProvider", HorizonStatisticProvider.HORIZON_FILE_SIZE_PROVIDER);
        return true;
    }

    @Override
    public void startupCompletedNotify() {
    }

    @Override
    public void shutdown() {
        UptimeStatisticProvider uptimeProvider = (UptimeStatisticProvider)this.getStatisticProvider("UptimeProvider");
        uptimeProvider.saveUptimeStats();
        DailyUptimeStatisticProvider dailyUptimeProvider = (DailyUptimeStatisticProvider)this.getStatisticProvider("DailyUptimeProvider");
        dailyUptimeProvider.shutdown();
        UploadDownloadCountStatistic.saveStats();
    }

    private static class Holder {
        protected static final StatisticsManager manager = new StatisticsManager();

        private Holder() {
        }
    }
}

