/*
 * Decompiled with CFR 0.152.
 */
package phex.statistic;

import phex.common.HorizonTracker;
import phex.common.IntObj;
import phex.common.LongObj;
import phex.statistic.StatisticProvider;

public class HorizonStatisticProvider
implements StatisticProvider {
    private static final short HOST_COUNT = 0;
    private static final short FILE_COUNT = 1;
    private static final short FILE_SIZE = 2;
    public static final HorizonStatisticProvider HORIZON_HOST_COUNT_PROVIDER = new HorizonStatisticProvider(0);
    public static final HorizonStatisticProvider HORIZON_FILE_COUNT_PROVIDER = new HorizonStatisticProvider(1);
    public static final HorizonStatisticProvider HORIZON_FILE_SIZE_PROVIDER = new HorizonStatisticProvider(2);
    private short type;
    private LongObj valueObj;
    private IntObj avgObj;

    public HorizonStatisticProvider(short type) {
        this.type = type;
        this.valueObj = new LongObj();
        switch (type) {
            case 1: 
            case 2: {
                this.avgObj = new IntObj();
            }
        }
    }

    @Override
    public Object getValue() {
        switch (this.type) {
            case 0: {
                this.valueObj.value = HorizonTracker.getInstance().getTotalHostCount();
                break;
            }
            case 1: {
                this.valueObj.value = HorizonTracker.getInstance().getTotalFileCount();
                break;
            }
            case 2: {
                this.valueObj.value = HorizonTracker.getInstance().getTotalFileSize();
            }
        }
        return this.valueObj;
    }

    @Override
    public Object getAverageValue() {
        switch (this.type) {
            case 2: {
                int val;
                HorizonTracker tracker = HorizonTracker.getInstance();
                long count = tracker.getTotalFileCount();
                if (count == 0L) break;
                this.avgObj.value = val = (int)((double)tracker.getTotalFileSize() / (double)count);
                break;
            }
            case 1: {
                int val;
                HorizonTracker tracker = HorizonTracker.getInstance();
                int hostCount = tracker.getTotalHostCount();
                if (hostCount == 0) break;
                this.avgObj.value = val = (int)((double)tracker.getTotalFileCount() / (double)hostCount);
            }
        }
        return this.avgObj;
    }

    @Override
    public Object getMaxValue() {
        return null;
    }

    @Override
    public String toStatisticString(Object value) {
        return value.toString();
    }
}

