/*
 * Decompiled with CFR 0.152.
 */
package phex.statistic;

import phex.common.IntObj;
import phex.common.format.TimeFormatUtils;
import phex.prefs.core.StatisticPrefs;
import phex.statistic.StatisticProvider;

public class DailyUptimeStatisticProvider
implements StatisticProvider {
    private static final int SECONDS_PER_DAY = 86400;
    private static final int WINDOW_MILLISECONDS = 604800000;
    private long startTime;
    private IntObj valueObj = new IntObj();

    public DailyUptimeStatisticProvider() {
        this.startUptimeMeasurement();
    }

    private void startUptimeMeasurement() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public Object getValue() {
        this.valueObj.setValue(this.calculateDailyUptime());
        return this.valueObj;
    }

    @Override
    public Object getAverageValue() {
        return null;
    }

    @Override
    public Object getMaxValue() {
        return null;
    }

    @Override
    public String toStatisticString(Object value) {
        return TimeFormatUtils.formatSignificantElapsedTime(((IntObj)value).intValue());
    }

    private int calculateDailyUptime() {
        return (int)(this.calculateFractionalUptime() * 86400.0f);
    }

    private float calculateFractionalUptime() {
        float W = 6.048E8f;
        float T = Math.min(6.048E8f, (float)(System.currentTimeMillis() - StatisticPrefs.LastShutdownTime.get()));
        float t = Math.min(6.048E8f, (float)(System.currentTimeMillis() - this.startTime));
        float P = StatisticPrefs.FractionalUptime.get().floatValue();
        if (t < 0.0f || T < 0.0f || t > T) {
            return P;
        }
        return t / 6.048E8f + (6.048E8f - T) / 6.048E8f * P;
    }

    public void shutdown() {
        StatisticPrefs.FractionalUptime.set(new Float(this.calculateFractionalUptime()));
        StatisticPrefs.LastShutdownTime.set(new Long(System.currentTimeMillis()));
    }
}

