/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.IOException;
import java.util.List;
import phex.common.Environment;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.io.buffer.ByteBuffer;
import phex.msg.GUID;
import phex.msg.MsgHeader;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.net.connection.Connection;
import phex.prefs.core.BandwidthPrefs;
import phex.prefs.core.LibraryPrefs;
import phex.servent.Servent;
import phex.share.ShareFile;
import phex.share.export.ExportEngine;
import phex.statistic.MessageCountStatistic;
import phex.utils.StringUtils;

public class HttpRequestDispatcher {
    public void httpRequestHandler(Connection connection, HTTPRequest httpRequest) {
        try {
            if (httpRequest.getRequestMethod().equals("GET")) {
                String requestURI = httpRequest.getRequestURI();
                if (requestURI.equals("/")) {
                    this.sendFileListing(httpRequest, connection);
                    return;
                }
                if (requestURI.equals("/robots.txt")) {
                    HTTPResponse response = new HTTPResponse(200, "OK", true);
                    response.addHeader(new HTTPHeader("Connection", "close"));
                    response.addHeader(new HTTPHeader("Content-Type", "text/plain"));
                    response.addHeader(new HTTPHeader("Content-Length", ""));
                    String httpData = response.buildHTTPResponseString();
                    String robotsText = "User-agent: *\r\nDisallow: /";
                    connection.write(ByteBuffer.wrap(StringUtils.getBytesInUsAscii(httpData)));
                    connection.write(ByteBuffer.wrap(StringUtils.getBytesInUsAscii(robotsText)));
                    return;
                }
            }
            this.sendErrorHTTP(connection, "404 Not Found", "File not found.");
        }
        catch (IOException exp) {
            NLogger.debug(HttpRequestDispatcher.class, (Object)exp, (Throwable)exp);
        }
    }

    private void sendErrorHTTP(Connection connection, String statusStr, String errMsg) throws IOException {
        StringBuffer content = new StringBuffer(300);
        content.append("<html><head><title>PHEX</title></head><body>");
        content.append(errMsg);
        content.append("<hr>Visit the Phex website at ");
        content.append("<a href=\"http://phex.sourceforge.net\">http://phex.sourceforge.net</a>.");
        content.append("</body>");
        content.append("</html>");
        StringBuffer buf = new StringBuffer(300);
        buf.append("HTTP/1.1 ").append(statusStr).append("\r\n");
        buf.append("Server: ").append(Environment.getPhexVendor()).append("\r\n");
        buf.append("Connection: close").append("\r\n");
        buf.append("Content-Type: text/plain").append("\r\n");
        buf.append("Content-Length: ").append(content.length()).append("\r\n");
        buf.append("\r\n");
        connection.write(ByteBuffer.wrap(StringUtils.getBytesInUsAscii(buf.toString())));
        connection.write(ByteBuffer.wrap(StringUtils.getBytesInUsAscii(content.toString())));
    }

    private void sendFileListing(HTTPRequest httpRequest, Connection connection) throws IOException {
        if (!LibraryPrefs.AllowBrowsing.get().booleanValue()) {
            HTTPHeaderGroup headers = HTTPHeaderGroup.createDefaultResponseHeaders();
            String response = this.createHTTPResponse("403 Browsing disabled", headers);
            connection.write(ByteBuffer.wrap(StringUtils.getBytesInUsAscii(response)));
            connection.flush();
            connection.disconnect();
            return;
        }
        HTTPHeader acceptHeader = httpRequest.getHeader("Accept");
        if (acceptHeader == null) {
            HTTPHeaderGroup headers = HTTPHeaderGroup.createDefaultResponseHeaders();
            String response = this.createHTTPResponse("406 Not Acceptable", headers);
            connection.write(ByteBuffer.wrap(StringUtils.getBytesInUsAscii(response)));
            connection.flush();
            connection.disconnect();
            return;
        }
        Servent servent = Servent.getInstance();
        String acceptHeaderStr = acceptHeader.getValue();
        if (acceptHeaderStr.indexOf("application/x-gnutella-packets") != -1) {
            int currentSendCount;
            HTTPHeaderGroup headers = HTTPHeaderGroup.createDefaultResponseHeaders();
            headers.addHeader(new HTTPHeader("Content-Type", "application/x-gnutella-packets"));
            headers.addHeader(new HTTPHeader("Connection", "close"));
            String response = this.createHTTPResponse("200 OK", headers);
            connection.write(ByteBuffer.wrap(StringUtils.getBytesInUsAscii(response)));
            connection.flush();
            List<ShareFile> shareFiles = servent.getSharedFilesService().getSharedFiles();
            MsgHeader header = new MsgHeader(new GUID(), -127, 2, 0, -1);
            int toSendCount = shareFiles.size();
            for (int sendCount = 0; sendCount < toSendCount; sendCount += currentSendCount) {
                currentSendCount = Math.min(255, toSendCount - sendCount);
                QueryResponseRecord[] records = new QueryResponseRecord[currentSendCount];
                for (int i = 0; i < currentSendCount; ++i) {
                    QueryResponseRecord record;
                    ShareFile sfile = shareFiles.get(sendCount + i);
                    records[i] = record = QueryResponseRecord.createFromShareFile(sfile);
                }
                DestAddress hostAddress = servent.getLocalAddress();
                QueryResponseMsg queryResponse = new QueryResponseMsg(header, servent.getServentGuid(), hostAddress, Math.round(BandwidthPrefs.MaxUploadBandwidth.get().floatValue() / 1024.0f), records, servent.getHostService().getNetworkHostsContainer().getPushProxies(), !servent.isFirewalled(), servent.isUploadLimitReached());
                ByteBuffer headerBuf = queryResponse.createHeaderBuffer();
                connection.write(headerBuf);
                ByteBuffer messageBuf = queryResponse.createMessageBuffer();
                connection.write(messageBuf);
                MessageCountStatistic.queryHitMsgOutCounter.increment(1);
            }
            connection.flush();
        } else if (acceptHeaderStr.indexOf("text/html") != -1 || acceptHeaderStr.indexOf("*/*") != -1) {
            HTTPHeaderGroup headers = HTTPHeaderGroup.createDefaultResponseHeaders();
            headers.addHeader(new HTTPHeader("Content-Type", "text/html; charset=iso-8859-1"));
            headers.addHeader(new HTTPHeader("Connection", "close"));
            String response = this.createHTTPResponse("200 OK", headers);
            connection.write(ByteBuffer.wrap(StringUtils.getBytesInUsAscii(response)));
            connection.flush();
            ExportEngine exportEngine = new ExportEngine(servent.getLocalAddress(), connection.getOutputStream(), servent.getSharedFilesService().getSharedFiles());
            exportEngine.startExport();
            connection.flush();
        }
        connection.disconnect();
    }

    private String createHTTPResponse(String code, HTTPHeaderGroup header) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("HTTP/1.1 ");
        buffer.append(code);
        buffer.append("\r\n");
        buffer.append(header.buildHTTPHeaderString());
        buffer.append("\r\n");
        return buffer.toString();
    }
}

