/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import phex.common.ThreadTracking;
import phex.common.log.NLogger;
import phex.prefs.core.LibraryPrefs;
import phex.share.ShareFile;
import phex.share.SharedDirectory;
import phex.share.SharedFilesService;
import phex.xml.sax.share.DSharedFile;
import phex.xml.sax.share.DSharedLibrary;

public class FileRescanRunner
implements Runnable {
    private static Thread rescanThread;
    private static final Object threadLock;
    private SharedFilesService sharedFilesService;
    private ArrayList<String> sharedDirectoryFiles;
    private List<Pattern> exclusionPatterns;
    private HashMap<File, SharedDirectory> sharedDirectoryMap;
    private HashSet<SharedDirectory> sharedDirectoryList;
    private boolean isInitialRescan;
    private HashMap<String, DSharedFile> sharedFilesCache;

    private FileRescanRunner(SharedFilesService sharedFilesSerivce, boolean isInitialRescan) {
        this.isInitialRescan = isInitialRescan;
        this.sharedFilesService = sharedFilesSerivce;
        this.exclusionPatterns = new ArrayList<Pattern>();
        this.sharedDirectoryMap = new HashMap();
        this.sharedDirectoryList = new HashSet(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rescan(SharedFilesService sharedFilesSerivce, boolean isInitialRescan, boolean allowInterrupt) {
        Object object = threadLock;
        synchronized (object) {
            if (allowInterrupt && rescanThread != null && !rescanThread.isInterrupted() && rescanThread.isAlive()) {
                NLogger.debug(FileRescanRunner.class, (Object)"Interrupting rescan thread.");
                rescanThread.interrupt();
                try {
                    NLogger.debug(FileRescanRunner.class, (Object)"Waiting for interrupted rescan thread.");
                    rescanThread.join();
                }
                catch (InterruptedException exp) {
                    NLogger.warn(FileRescanRunner.class, (Object)exp, (Throwable)exp);
                }
            }
            if (rescanThread == null || !rescanThread.isAlive()) {
                FileRescanRunner runner = new FileRescanRunner(sharedFilesSerivce, isInitialRescan);
                rescanThread = new Thread(ThreadTracking.rootThreadGroup, runner, "FileRescanRunner-" + Integer.toHexString(runner.hashCode()));
                rescanThread.setDaemon(true);
                rescanThread.setPriority(1);
                rescanThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sync() {
        Object object = threadLock;
        synchronized (object) {
            if (rescanThread != null && rescanThread.isAlive()) {
                try {
                    NLogger.debug(FileRescanRunner.class, (Object)"Waiting for running rescan thread.");
                    rescanThread.join();
                }
                catch (InterruptedException exp) {
                    NLogger.warn(FileRescanRunner.class, (Object)exp, (Throwable)exp);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NLogger.debug(FileRescanRunner.class, (Object)("Staring file rescan (Initial: " + this.isInitialRescan + ")."));
        this.sharedDirectoryFiles = new ArrayList(LibraryPrefs.SharedDirectoriesSet.get());
        this.setExclusionFilter(LibraryPrefs.LibraryExclusionRegExList.get());
        if (rescanThread.isInterrupted()) {
            return;
        }
        if (this.isInitialRescan) {
            this.sharedFilesService.clearSharedFiles();
            if (rescanThread.isInterrupted()) {
                return;
            }
            this.buildSharedFilesCache();
        } else {
            this.removeUnsharedFiles();
        }
        if (rescanThread.isInterrupted()) {
            return;
        }
        try {
            this.sharedFilesService.setCalculationRunnerPause(true);
            HashMap<String, String> scannedDirMap = new HashMap<String, String>();
            for (String dirStr : this.sharedDirectoryFiles) {
                File dir = new File(dirStr);
                this.scanDir(dir, scannedDirMap);
                if (!rescanThread.isInterrupted()) continue;
                return;
            }
            this.sharedFilesService.updateSharedDirecotries(this.sharedDirectoryMap, this.sharedDirectoryList);
            this.sharedFilesService.triggerSaveSharedFiles();
        }
        finally {
            this.sharedFilesService.setCalculationRunnerPause(false);
        }
    }

    private void buildSharedFilesCache() {
        this.sharedFilesCache = new HashMap();
        DSharedLibrary library = this.sharedFilesService.loadSharedLibrary();
        if (library == null) {
            return;
        }
        Iterator iterator = library.getSubElementList().iterator();
        while (iterator.hasNext() && !rescanThread.isInterrupted()) {
            DSharedFile cachedFile = (DSharedFile)iterator.next();
            this.sharedFilesCache.put(cachedFile.getFileName(), cachedFile);
        }
    }

    private void scanDir(File dir, HashMap<String, String> scannedDirMap) {
        File[] files;
        String canonicalPath;
        try {
            canonicalPath = dir.getCanonicalPath();
        }
        catch (IOException exp) {
            NLogger.warn(FileRescanRunner.class, (Object)exp, (Throwable)exp);
            return;
        }
        if (scannedDirMap.containsKey(canonicalPath)) {
            return;
        }
        scannedDirMap.put(canonicalPath, "");
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            this.handleScannedDir(dir);
        }
        if ((files = dir.listFiles()) == null) {
            NLogger.error(FileRescanRunner.class, (Object)("'" + dir + "' is not a directory."));
            return;
        }
        for (int j = 0; j < files.length && !rescanThread.isInterrupted(); ++j) {
            if (this.isFileInvalid(files[j]) || !files[j].isFile()) continue;
            this.handleScannedFile(files[j]);
        }
    }

    private void handleScannedDir(File file) {
        SharedDirectory sharedDirectory;
        if (rescanThread.isInterrupted()) {
            return;
        }
        if (this.isInitialRescan) {
            sharedDirectory = this.sharedDirectoryMap.get(file);
            if (sharedDirectory == null) {
                sharedDirectory = new SharedDirectory(file);
                sharedDirectory.setType((short)1);
                this.sharedDirectoryMap.put(file, sharedDirectory);
                this.sharedDirectoryList.add(sharedDirectory);
            } else {
                sharedDirectory.setType((short)1);
            }
        } else {
            sharedDirectory = this.sharedDirectoryMap.get(file);
            if (sharedDirectory == null) {
                sharedDirectory = new SharedDirectory(file);
                sharedDirectory.setType((short)1);
                this.sharedDirectoryMap.put(file, sharedDirectory);
                this.sharedDirectoryList.add(sharedDirectory);
            } else {
                sharedDirectory.setType((short)1);
            }
        }
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (!parent.isDirectory() || (sharedDirectory = this.sharedDirectoryMap.get(parent)) != null) continue;
            sharedDirectory = new SharedDirectory(parent);
            sharedDirectory.setType((short)2);
            this.sharedDirectoryMap.put(parent, sharedDirectory);
            this.sharedDirectoryList.add(sharedDirectory);
        }
    }

    private void handleScannedFile(File file) {
        if (this.isInitialRescan) {
            ShareFile shareFile = new ShareFile(file);
            DSharedFile dFile = this.sharedFilesCache.get(file.getAbsolutePath());
            if (dFile != null && dFile.getLastModified() == file.lastModified()) {
                shareFile.updateFromCache(dFile);
                this.sharedFilesService.addUrn2FileMapping(shareFile);
            } else {
                this.sharedFilesService.queueUrnCalculation(shareFile);
                if (rescanThread.isInterrupted()) {
                    return;
                }
            }
            this.sharedFilesService.addSharedFile(shareFile);
        } else {
            ShareFile shareFile = this.sharedFilesService.getFileByName(file.getAbsolutePath());
            if (shareFile == null) {
                shareFile = new ShareFile(file);
                this.sharedFilesService.queueUrnCalculation(shareFile);
                if (rescanThread.isInterrupted()) {
                    return;
                }
                this.sharedFilesService.addSharedFile(shareFile);
            }
        }
    }

    private void removeUnsharedFiles() {
        List<ShareFile> sharedFiles = this.sharedFilesService.getSharedFiles();
        int size = sharedFiles.size();
        for (int i = 0; i < size && !rescanThread.isInterrupted(); ++i) {
            ShareFile shareFile = sharedFiles.get(i);
            File file = shareFile.getSystemFile();
            if (this.isInSharedDirectory(file) && file.exists()) continue;
            this.sharedFilesService.removeSharedFile(shareFile);
        }
    }

    private boolean isInSharedDirectory(File file) {
        for (String dir : this.sharedDirectoryFiles) {
            File sharedDirFile = new File(dir);
            if (!file.getParentFile().equals(sharedDirFile)) continue;
            return true;
        }
        return false;
    }

    private void setSharedDirectories(String dirs) {
        StringTokenizer tokens = new StringTokenizer(dirs, ";");
        int count = tokens.countTokens();
        this.sharedDirectoryFiles.clear();
        this.sharedDirectoryFiles.ensureCapacity(count);
        while (tokens.hasMoreTokens()) {
            String dir = tokens.nextToken().trim();
            if (this.sharedDirectoryFiles.contains(dir)) continue;
            this.sharedDirectoryFiles.add(dir);
        }
    }

    private void setExclusionFilter(List<String> exclusionList) {
        this.exclusionPatterns.clear();
        for (String regExp : exclusionList) {
            try {
                Pattern pattern = Pattern.compile(regExp);
                this.exclusionPatterns.add(pattern);
            }
            catch (PatternSyntaxException exp) {
                NLogger.error(FileRescanRunner.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    public boolean isFileInvalid(File file) {
        if (file.getName().toLowerCase().endsWith(".dl")) {
            return true;
        }
        return this.isExcludedRegExp(file);
    }

    private boolean isExcludedRegExp(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String name = file.getName();
        for (Pattern pattern : this.exclusionPatterns) {
            Matcher m = pattern.matcher(name);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    static {
        threadLock = new Object();
    }
}

