/*
 * Decompiled with CFR 0.152.
 */
package phex.servent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import phex.chat.ChatService;
import phex.common.AbstractLifeCycle;
import phex.common.GnutellaNetwork;
import phex.common.LifeCycle;
import phex.common.MultipleException;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.event.ChangeEvent;
import phex.event.PhexEventService;
import phex.event.PhexEventServiceImpl;
import phex.host.HostFetchingStrategy;
import phex.host.HostManager;
import phex.host.I2PHostFetchingStrategy;
import phex.host.UltrapeerCapabilityChecker;
import phex.msg.GUID;
import phex.msghandling.MessageService;
import phex.net.I2PServer;
import phex.net.OnlineObserver;
import phex.net.Server;
import phex.prefs.core.ConnectionPrefs;
import phex.prefs.core.NetworkPrefs;
import phex.query.QueryManager;
import phex.servent.OnlineStatus;
import phex.servent.ServentInfo;
import phex.share.SharedFilesService;
import phex.upload.UploadManager;
import phex.utils.StringUtils;

public class Servent
extends AbstractLifeCycle
implements ServentInfo {
    private static final Servent servent = new Servent();
    private final List<LifeCycle> dependentLifeCycles;
    private GUID serventGuid;
    private GnutellaNetwork gnutellaNetwork;
    private Server server;
    private OnlineStatus onlineStatus = OnlineStatus.OFFLINE;
    private final PhexEventService serventEventService;
    private final OnlineObserver onlineObserver;
    private final HostFetchingStrategy hostFetchingStrategy;
    private final ChatService chatService;
    private final MessageService messageService;
    private final UploadManager uploadService;
    private final QueryManager queryService;
    private final HostManager hostService;
    private final SharedFilesService sharedFilesService;
    private UltrapeerCapabilityChecker upChecker;

    public static Servent getInstance() {
        return servent;
    }

    private Servent() {
        this.dependentLifeCycles = new ArrayList<LifeCycle>();
        this.serventEventService = new PhexEventServiceImpl();
        String serventGuidStr = NetworkPrefs.ServentGuid.get();
        if (StringUtils.isEmpty(serventGuidStr)) {
            this.serventGuid = new GUID();
            NetworkPrefs.ServentGuid.set(this.serventGuid.toHexString());
        } else {
            try {
                this.serventGuid = new GUID(serventGuidStr);
            }
            catch (Exception exp) {
                NLogger.warn(Servent.class, (Object)exp, (Throwable)exp);
                this.serventGuid = new GUID();
                NetworkPrefs.ServentGuid.set(this.serventGuid.toHexString());
            }
        }
        String networkName = NetworkPrefs.CurrentNetwork.get();
        this.gnutellaNetwork = GnutellaNetwork.getGnutellaNetworkFromString(networkName);
        if (ConnectionPrefs.AutoConnectOnStartup.get().booleanValue()) {
            this.setOnlineStatus(OnlineStatus.ONLINE);
        } else {
            this.setOnlineStatus(OnlineStatus.OFFLINE);
        }
        this.sharedFilesService = new SharedFilesService(this);
        this.dependentLifeCycles.add(this.sharedFilesService);
        this.chatService = new ChatService(this);
        this.uploadService = new UploadManager(this);
        this.hostFetchingStrategy = new I2PHostFetchingStrategy(this);
        this.hostService = new HostManager(this);
        this.dependentLifeCycles.add(this.hostService);
        this.messageService = new MessageService(this);
        this.dependentLifeCycles.add(this.messageService);
        this.queryService = new QueryManager(this);
        this.dependentLifeCycles.add(this.queryService);
        this.onlineObserver = new OnlineObserver(this, this.hostFetchingStrategy);
        this.server = new I2PServer();
    }

    @Override
    protected void doStart() throws Exception {
        MultipleException multiExp = new MultipleException();
        this.hostFetchingStrategy.postManagerInitRoutine();
        try {
            this.server.startup();
        }
        catch (IOException exp) {
            NLogger.error(Servent.class, (Object)exp, (Throwable)exp);
        }
        this.upChecker = new UltrapeerCapabilityChecker(this);
        if (!this.dependentLifeCycles.isEmpty()) {
            ListIterator<LifeCycle> iterator = this.dependentLifeCycles.listIterator(this.dependentLifeCycles.size());
            while (iterator.hasPrevious()) {
                try {
                    iterator.previous().start();
                }
                catch (Throwable e) {
                    multiExp.add(e);
                }
            }
        }
        multiExp.throwPossibleExp();
    }

    @Override
    protected void doStop() throws Exception {
        MultipleException multiExp = new MultipleException();
        this.server.shutdown(false);
        if (!this.dependentLifeCycles.isEmpty()) {
            ListIterator<LifeCycle> iterator = this.dependentLifeCycles.listIterator(this.dependentLifeCycles.size());
            while (iterator.hasPrevious()) {
                try {
                    iterator.previous().stop();
                }
                catch (Throwable e) {
                    multiExp.add(e);
                }
            }
        }
        multiExp.throwPossibleExp();
    }

    public ChatService getChatService() {
        return this.chatService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public HostManager getHostService() {
        return this.hostService;
    }

    public UploadManager getUploadService() {
        return this.uploadService;
    }

    public QueryManager getQueryService() {
        return this.queryService;
    }

    public SharedFilesService getSharedFilesService() {
        return this.sharedFilesService;
    }

    @Override
    public PhexEventService getEventService() {
        return this.serventEventService;
    }

    @Override
    public boolean isUltrapeer() {
        return this.hostService.isUltrapeer();
    }

    @Override
    public boolean isShieldedLeafNode() {
        return this.hostService.isShieldedLeafNode();
    }

    @Override
    public boolean isAbleToBecomeUltrapeer() {
        if (this.isUltrapeer()) {
            return true;
        }
        return !this.isShieldedLeafNode() && ConnectionPrefs.AllowToBecomeUP.get() != false && this.upChecker.isUltrapeerCapable();
    }

    @Override
    public boolean isAbleToBecomeLeafNode() {
        return this.hostService.isAbleToBecomeLeafNode();
    }

    @Override
    public boolean isFirewalled() {
        return !this.server.hasConnectedIncoming();
    }

    public boolean isUdpHostCache() {
        return false;
    }

    @Override
    public boolean isUploadLimitReached() {
        return this.uploadService.isHostBusy();
    }

    @Override
    public DestAddress getLocalAddress() {
        return this.server.getLocalAddress();
    }

    public void updateLocalAddress(DestAddress newAddress) {
        this.server.updateLocalAddress(newAddress);
    }

    public void restartServer() throws IOException {
        this.server.restart();
    }

    @Override
    public GUID getServentGuid() {
        return this.serventGuid;
    }

    public OnlineStatus getOnlineStatus() {
        return this.onlineStatus;
    }

    public void setOnlineStatus(OnlineStatus newStatus) {
        if (newStatus == this.onlineStatus) {
            return;
        }
        OnlineStatus oldStatus = this.onlineStatus;
        this.onlineStatus = newStatus;
        this.serventEventService.publish("phex:servent/onlineStatus", new ChangeEvent(this, (Object)oldStatus, (Object)newStatus));
    }

    @Override
    public GnutellaNetwork getGnutellaNetwork() {
        return this.gnutellaNetwork;
    }

    public void setGnutellaNetwork(GnutellaNetwork network) {
        OnlineStatus oldStatus = this.onlineStatus;
        this.setOnlineStatus(OnlineStatus.OFFLINE);
        GnutellaNetwork oldNetwork = this.gnutellaNetwork;
        this.gnutellaNetwork = network;
        this.serventEventService.publish("phex:servent/gnutellaNetwork", new ChangeEvent(this, oldNetwork, this.gnutellaNetwork));
        this.setOnlineStatus(oldStatus);
    }

    public HostFetchingStrategy getHostFetchingStrategy() {
        return this.hostFetchingStrategy;
    }
}

