/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import java.lang.ref.SoftReference;
import phex.common.ExpiryDate;
import phex.common.address.AddressUtils;
import phex.security.HittingIpCidrPair;
import phex.security.IpSecurityRule;
import phex.xml.sax.security.DIpAccessRule;
import phex.xml.sax.security.DSecurityRule;

public class IpSystemSecurityRule
implements IpSecurityRule {
    private final HittingIpCidrPair ipCidrPair;
    private SoftReference<String> addressString;

    public IpSystemSecurityRule(int ip, byte cidr) {
        this.ipCidrPair = new HittingIpCidrPair(ip, cidr);
    }

    @Override
    public String getAddressString() {
        if (this.addressString == null || this.addressString.get() == null) {
            this.addressString = this.ipCidrPair.cidr == 32 ? new SoftReference<String>(AddressUtils.ip2string(this.ipCidrPair.ipAddr)) : new SoftReference<String>(AddressUtils.ip2string(this.ipCidrPair.ipAddr) + " / " + String.valueOf(this.ipCidrPair.cidr));
        }
        return this.addressString.get();
    }

    @Override
    public HittingIpCidrPair getIpCidrPair() {
        return this.ipCidrPair;
    }

    @Override
    public int getIp() {
        return this.ipCidrPair.ipAddr;
    }

    @Override
    public int getTriggerCount() {
        return this.ipCidrPair.getHits();
    }

    @Override
    public void setTriggerCount(int count) {
        this.ipCidrPair.setHits(count);
    }

    @Override
    public boolean isDenyingRule() {
        return true;
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public boolean isSystemRule() {
        return true;
    }

    @Override
    public boolean isDeletedOnExpiry() {
        return false;
    }

    @Override
    public ExpiryDate getExpiryDate() {
        return ExpiryDate.NEVER_EXPIRY_DATE;
    }

    @Override
    public String getDescription() {
        return "System rule.";
    }

    @Override
    public DSecurityRule createDSecurityRule() {
        DIpAccessRule dRule = new DIpAccessRule();
        dRule.setSystemRule(true);
        dRule.setIp(AddressUtils.intIp2ByteIp(this.ipCidrPair.ipAddr));
        dRule.setCidr(this.ipCidrPair.cidr);
        dRule.setTriggerCount(this.ipCidrPair.getHits());
        return dRule;
    }
}

