/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import phex.common.collections.PatriciaTrie;
import phex.common.collections.Trie;
import phex.security.HittingIpCidrPair;
import phex.security.IpCidrPair;
import phex.security.IpSecurityRule;
import phex.security.IpSystemSecurityRule;

public class IpSystemRuleList {
    private PatriciaTrie<IpCidrPair, IpCidrPair> ipTrie = new PatriciaTrie(new IpKeyAnalyzer());

    public void add(IpSecurityRule rule) {
        AddFilter filter;
        HittingIpCidrPair addPair = rule.getIpCidrPair();
        Map.Entry<IpCidrPair, IpCidrPair> entry = this.ipTrie.select(addPair, filter = new AddFilter(addPair));
        if (entry != null) {
            if (!entry.getKey().contains(addPair)) {
                for (IpCidrPair obsolete : filter.getContained()) {
                    this.ipTrie.remove(obsolete);
                }
                this.ipTrie.put(addPair, addPair);
            }
        } else {
            this.ipTrie.put(addPair, addPair);
        }
    }

    public void remove(IpSecurityRule rule) {
        AddFilter filter;
        HittingIpCidrPair removePair = rule.getIpCidrPair();
        Map.Entry<IpCidrPair, IpCidrPair> entry = this.ipTrie.select(removePair, filter = new AddFilter(removePair));
        if (entry != null && !entry.getKey().contains(removePair)) {
            for (IpCidrPair obsolete : filter.getContained()) {
                this.ipTrie.remove(obsolete);
            }
        }
        this.ipTrie.remove(removePair);
    }

    public boolean contains(IpSystemSecurityRule rule) {
        HittingIpCidrPair lookupPair = rule.getIpCidrPair();
        return this.contains(lookupPair);
    }

    public boolean contains(IpCidrPair lookupPair) {
        HittingIpCidrPair pair = (HittingIpCidrPair)this.ipTrie.select(lookupPair);
        if (pair == null) {
            return false;
        }
        if (!pair.contains(lookupPair)) {
            return false;
        }
        pair.countHit();
        return true;
    }

    private static class IpKeyAnalyzer
    implements PatriciaTrie.KeyAnalyzer<IpCidrPair> {
        private static final int[] BITS = IpKeyAnalyzer.createIntBitMask(32);

        private IpKeyAnalyzer() {
        }

        private static final int[] createIntBitMask(int bitCount) {
            int[] bits = new int[bitCount];
            for (int i = 0; i < bitCount; ++i) {
                bits[i] = 1 << bitCount - i - 1;
            }
            return bits;
        }

        @Override
        public int length(IpCidrPair key) {
            return 32;
        }

        @Override
        public boolean isBitSet(IpCidrPair key, int keyLength, int bitIndex) {
            int maddr = key.ipAddr & key.getNetMask();
            return (maddr & BITS[bitIndex]) != 0;
        }

        @Override
        public int bitIndex(IpCidrPair key, int keyOff, int keyLength, IpCidrPair found, int foundOff, int foundKeyLength) {
            int maddr2;
            int maddr1 = key.ipAddr & key.getNetMask();
            int n = maddr2 = found != null ? found.ipAddr & found.getNetMask() : 0;
            if (keyOff != 0 || foundOff != 0) {
                throw new IllegalArgumentException("offsets must be 0 for fixed-size keys");
            }
            int length = Math.max(keyLength, foundKeyLength);
            boolean allNull = true;
            for (int i = 0; i < length; ++i) {
                int a = maddr1 & BITS[i];
                int b = maddr2 & BITS[i];
                if (allNull && a != 0) {
                    allNull = false;
                }
                if (a == b) continue;
                return i;
            }
            if (allNull) {
                return -1;
            }
            return -2;
        }

        @Override
        public int compare(IpCidrPair o1, IpCidrPair o2) {
            int addr2;
            int addr1 = o1.ipAddr & o1.getNetMask();
            if (addr1 > (addr2 = o2.ipAddr & o2.getNetMask())) {
                return 1;
            }
            if (addr1 < addr2) {
                return -1;
            }
            return 0;
        }

        @Override
        public int bitsPerElement() {
            return 1;
        }

        @Override
        public boolean isPrefix(IpCidrPair prefix, int offset, int length, IpCidrPair key) {
            int addr1 = prefix.ipAddr & prefix.getNetMask();
            int addr2 = key.ipAddr & key.getNetMask();
            addr1 <<= offset;
            int mask = 0;
            for (int i = 0; i < length; ++i) {
                mask |= 1 << i;
            }
            return (addr1 &= mask) == (addr2 &= mask);
        }
    }

    private static class AddFilter
    implements Trie.Cursor<IpCidrPair, IpCidrPair> {
        private final IpCidrPair lookup;
        private List<IpCidrPair> contained;

        AddFilter(IpCidrPair lookup) {
            this.lookup = lookup;
        }

        public List<IpCidrPair> getContained() {
            if (this.contained == null) {
                return Collections.emptyList();
            }
            return this.contained;
        }

        @Override
        public Trie.Cursor.SelectStatus select(Map.Entry<? extends IpCidrPair, ? extends IpCidrPair> entry) {
            IpCidrPair compare = entry.getKey();
            if (compare.contains(this.lookup)) {
                return Trie.Cursor.SelectStatus.EXIT;
            }
            if (this.lookup.contains(compare)) {
                if (this.contained == null) {
                    this.contained = new ArrayList<IpCidrPair>();
                }
                this.contained.add(compare);
                return Trie.Cursor.SelectStatus.CONTINUE;
            }
            return Trie.Cursor.SelectStatus.EXIT;
        }
    }
}

