/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import java.util.Stack;
import phex.common.ExpiryDate;
import phex.common.RunnerQueueWorker;
import phex.common.ThreadTracking;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.security.AccessType;
import phex.security.PhexSecurityManager;
import phex.utils.Localizer;

public class BanHostBatch
extends RunnerQueueWorker {
    private static Object lock = new Object();
    private static BanHostBatch instance;
    private Thread runnerThread;
    private Stack<BanHostHolder> rules = new Stack();

    private BanHostBatch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                NLogger.debug(BanHostBatch.class, (Object)"Creating Instance");
                instance = new BanHostBatch();
            }
            if (BanHostBatch.instance.runnerThread == null) {
                instance.createRunner();
            }
        }
    }

    private synchronized void createRunner() {
        NLogger.debug(BanHostBatch.class, (Object)"Creating RunnerThread");
        this.runnerThread = new Thread(ThreadTracking.rootThreadGroup, new BatchWorker());
        this.runnerThread.setPriority(5);
        this.runnerThread.setDaemon(true);
        this.runnerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDestAddress(DestAddress address, ExpiryDate expDate) {
        Object object = lock;
        synchronized (object) {
            BanHostBatch.init();
            BanHostBatch.instance.rules.add(new BanHostHolder(address, expDate));
        }
        object = instance;
        synchronized (object) {
            instance.notify();
        }
    }

    private static class BanHostHolder {
        private DestAddress address;
        private ExpiryDate expDate;

        public BanHostHolder(DestAddress address, ExpiryDate expDate) {
            this.address = address;
            this.expDate = expDate;
        }
    }

    private class BatchWorker
    implements Runnable {
        private BatchWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            PhexSecurityManager securityMgr = PhexSecurityManager.getInstance();
            try {
                while (true) {
                    BanHostHolder next;
                    AccessType access;
                    if ((access = securityMgr.controlHostAddressAccess((next = (BanHostHolder)BanHostBatch.this.rules.pop()).address)) == AccessType.ACCESS_GRANTED) {
                        securityMgr.createIPAccessRule(Localizer.getString("UserBanned"), next.address.getIpAddress().getHostIP(), (byte)32, false, next.expDate, true);
                    }
                    BanHostBatch banHostBatch = instance;
                    synchronized (banHostBatch) {
                        if (BanHostBatch.this.rules.isEmpty()) {
                            instance.wait(30000L);
                        }
                        if (BanHostBatch.this.rules.isEmpty()) break;
                    }
                }
                {
                    BanHostBatch.this.runnerThread = null;
                    NLogger.debug(BanHostBatch.class, (Object)"Releasing RunnerThread");
                }
            }
            catch (Throwable th) {
                BanHostBatch.this.runnerThread = null;
                NLogger.error(BanHostBatch.class, (Object)th, th);
            }
            Object object = lock;
            synchronized (object) {
                if (!BanHostBatch.this.rules.isEmpty()) {
                    BanHostBatch.this.createRunner();
                } else {
                    instance = null;
                }
                return;
            }
        }
    }
}

