/*
 * Decompiled with CFR 0.152.
 */
package phex.rules.condition;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import phex.download.RemoteFile;
import phex.query.Search;
import phex.rules.condition.Condition;
import phex.xml.sax.rules.DCondition;

public class RegexpFilenameCondition
implements Condition {
    private String expression;
    private Pattern filterPattern;

    public RegexpFilenameCondition(String expression, boolean ignoreCase) {
        this.expression = expression;
        int flags = 0;
        if (ignoreCase) {
            flags = 66;
        }
        this.filterPattern = Pattern.compile(expression, flags);
    }

    @Override
    public boolean isMatched(Search search, RemoteFile remoteFile) {
        String filename = remoteFile.getFilename();
        Matcher m = this.filterPattern.matcher(filename);
        return m.matches();
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized DCondition createDCondition() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }
}

