/*
 * Decompiled with CFR 0.152.
 */
package phex.rules.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;
import phex.common.MediaType;
import phex.download.RemoteFile;
import phex.query.Search;
import phex.rules.condition.Condition;
import phex.xml.sax.rules.DCondition;
import phex.xml.sax.rules.DMediaTypeCondition;

public class MediaTypeCondition
implements Condition {
    private ListOrderedSet types = new ListOrderedSet();

    public MediaTypeCondition() {
    }

    public MediaTypeCondition(MediaType type) {
        this();
        this.addType(type);
    }

    public MediaTypeCondition(MediaTypeCondition condition) {
        this();
        this.update(condition);
    }

    public synchronized void update(MediaTypeCondition condition) {
        this.types.clear();
        this.types.addAll((Collection)condition.types);
    }

    public synchronized Set<MediaType> getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    public synchronized MediaTypeCondition addType(MediaType type) {
        this.types.add((Object)type);
        return this;
    }

    public synchronized void removeType(MediaType type) {
        this.types.remove((Object)type);
    }

    @Override
    public synchronized boolean isMatched(Search search, RemoteFile remoteFile) {
        for (MediaType type : this.types) {
            if (!type.isFilenameOf(remoteFile.getFilename())) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.types.size() > 0;
    }

    @Override
    public synchronized Object clone() {
        try {
            MediaTypeCondition clone = (MediaTypeCondition)super.clone();
            clone.types = new ListOrderedSet();
            clone.types.addAll((Collection)this.types);
            return clone;
        }
        catch (CloneNotSupportedException exp) {
            throw new InternalError();
        }
    }

    @Override
    public synchronized DCondition createDCondition() {
        DMediaTypeCondition dCond = new DMediaTypeCondition();
        ArrayList<MediaType> newList = new ArrayList<MediaType>((Collection<MediaType>)this.types);
        dCond.setTypes(newList);
        return dCond;
    }
}

