/*
 * Decompiled with CFR 0.152.
 */
package phex.rules.condition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import phex.rules.condition.Condition;

public abstract class ConcatCondition
implements Condition,
Cloneable {
    protected List<Condition> filterList = new ArrayList<Condition>();

    public int getConditionCount() {
        return this.filterList.size();
    }

    public List<Condition> getConditions() {
        return Collections.unmodifiableList(this.filterList);
    }

    public synchronized void clearConditions() {
        this.filterList.clear();
    }

    public synchronized ConcatCondition addCondition(Condition filter) {
        this.filterList.add(filter);
        return this;
    }

    public synchronized void removeCondition(Condition filter) {
        this.filterList.remove(filter);
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public Object clone() {
        try {
            ConcatCondition clone = (ConcatCondition)super.clone();
            clone.filterList = new ArrayList<Condition>();
            for (Condition condition : this.filterList) {
                clone.filterList.add((Condition)condition.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        return super.toString() + "[List: " + this.filterList.toString() + "]";
    }
}

