/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.common.IntObj;
import phex.common.URN;
import phex.common.log.NLogger;
import phex.download.RemoteFile;
import phex.event.AsynchronousDispatcher;
import phex.msg.InvalidMessageException;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.query.DynamicQueryEngine;
import phex.query.QueryManager;
import phex.query.SearchDataEvent;
import phex.query.SearchResultHolder;
import phex.security.AccessType;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;

public abstract class Search {
    protected long startTime;
    protected DynamicQueryEngine queryEngine;
    protected QueryMsg queryMsg;
    private IntObj progressObj = new IntObj();
    protected boolean isSearching = false;
    protected SearchResultHolder searchResultHolder = new SearchResultHolder();

    protected Search() {
    }

    public int getQueryHitCount() {
        return this.searchResultHolder.getQueryHitCount();
    }

    public int getProgress() {
        if (!this.isSearching) {
            return 100;
        }
        if (this.queryEngine != null) {
            return this.queryEngine.getProgress();
        }
        long currentTime = System.currentTimeMillis();
        int timeProgress = (int)(100.0 - (double)(this.startTime + 300000L - currentTime) / 300000.0 * 100.0);
        return Math.min(timeProgress, 100);
    }

    public IntObj getProgressObj() {
        int progress = this.getProgress();
        if (this.progressObj.value != progress) {
            this.progressObj.value = progress;
        }
        return this.progressObj;
    }

    public boolean isSearching() {
        return this.isSearching;
    }

    public void checkForSearchTimeout(long currentTime) {
        if (this.queryEngine != null) {
            if (this.queryEngine.isQueryFinished()) {
                this.stopSearching();
            }
        } else if (currentTime > this.startTime + 300000L) {
            this.stopSearching();
        }
    }

    public void startSearching(final QueryManager queryService) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            @Override
            public void run() {
                Search.this.startTime = System.currentTimeMillis();
                Search.this.queryMsg.setCreationTime(Search.this.startTime);
                NLogger.debug(Search.class, (Object)("Sending Query " + Search.this.queryMsg));
                Search.this.queryEngine = queryService.sendMyQuery(Search.this.queryMsg);
                Search.this.isSearching = true;
                Search.this.fireSearchStarted();
            }
        });
    }

    public void stopSearching() {
        if (!this.isSearching) {
            return;
        }
        this.isSearching = false;
        if (this.queryEngine != null) {
            this.queryEngine.stopQuery();
        }
        this.fireSearchStoped();
    }

    protected boolean isResponseRecordValid(QueryResponseRecord record) {
        URN urn;
        PhexSecurityManager securityMgr = PhexSecurityManager.getInstance();
        if (securityMgr.controlUrnAccess(urn = record.getURN()) != AccessType.ACCESS_GRANTED) {
            NLogger.debug(Search.class, (Object)("Record contains blocked URN: " + urn.getAsString()));
            return false;
        }
        return true;
    }

    public abstract void processResponse(QueryResponseMsg var1) throws InvalidMessageException;

    protected void fireSearchStarted() {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 0);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchStoped() {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 4);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    public void fireSearchChanged() {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 3);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchHitsAdded(RemoteFile[] newHits) {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 1, newHits);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    private void fireSearchChangeEvent(SearchDataEvent searchChangeEvent) {
        Servent.getInstance().getEventService().publish("phex:search/data", searchChangeEvent);
    }
}

