/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang.SystemUtils;
import phex.common.log.NLogger;
import phex.host.Host;
import phex.msg.QueryMsg;
import phex.msghandling.MessageSubscriber;

public class QueryMsgToWriterMonitor
implements MessageSubscriber<QueryMsg> {
    private Writer outputWriter;

    public QueryMsgToWriterMonitor(Writer outputWriter) {
        this.outputWriter = outputWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(QueryMsg query, Host sourceHost) {
        if (this.outputWriter == null) {
            return;
        }
        String searchString = query.getSearchString();
        if (searchString.length() > 0 && !searchString.equals("\\") && !searchString.startsWith("urn:sha1:")) {
            Writer writer = this.outputWriter;
            synchronized (writer) {
                try {
                    this.outputWriter.write(query.getSearchString());
                    this.outputWriter.write(SystemUtils.LINE_SEPARATOR);
                }
                catch (IOException exp) {
                    NLogger.error(QueryMsgToWriterMonitor.class, (Object)exp.getMessage(), (Throwable)exp);
                    this.outputWriter = null;
                }
            }
        }
    }
}

