/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.host.Host;
import phex.msg.QueryMsg;
import phex.msghandling.MessageSubscriber;
import phex.prefs.core.StatisticPrefs;
import phex.servent.Servent;
import phex.utils.CircularQueue;

public class QueryHistoryMonitor
implements MessageSubscriber<QueryMsg> {
    private boolean isHistoryMonitored = false;
    private CircularQueue historyQueue = new CircularQueue(StatisticPrefs.QueryHistoryEntries.get(), StatisticPrefs.QueryHistoryEntries.get());

    public void setHistoryMonitored(boolean state) {
        this.isHistoryMonitored = state;
    }

    public boolean isHistoryMonitored() {
        return this.isHistoryMonitored;
    }

    public synchronized void setMaxHistroySize(int size) {
        if (size == this.historyQueue.getCapacity()) {
            return;
        }
        this.historyQueue = new CircularQueue(size, size);
        StatisticPrefs.QueryHistoryEntries.set(new Integer(size));
    }

    public synchronized int getMaxHistorySize() {
        return this.historyQueue.getCapacity();
    }

    public synchronized int getHistorySize() {
        return this.historyQueue.getSize();
    }

    public synchronized QueryMsg getSearchQueryAt(int index) {
        return (QueryMsg)this.historyQueue.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(QueryMsg query, Host sourceHost) {
        QueryHistoryMonitor queryHistoryMonitor = this;
        synchronized (queryHistoryMonitor) {
            if (!this.isHistoryMonitored) {
                return;
            }
            String searchString = query.getSearchString();
            if (searchString.length() > 0 && !searchString.equals("\\") && !searchString.startsWith("urn:sha1:")) {
                this.historyQueue.addToHead(query);
                this.fireQueryHistoryChanged();
            }
        }
    }

    private void fireQueryHistoryChanged() {
        Servent.getInstance().getEventService().publish("phex:query/monitor", "");
    }
}

