/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.StringTokenizer;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.download.RemoteFile;
import phex.msg.InvalidMessageException;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.prefs.core.MessagePrefs;
import phex.query.QueryHitHost;
import phex.query.Search;
import phex.utils.SearchEngine;

public class KeywordSearch
extends Search {
    private String searchString;
    private URN searchURN;

    public KeywordSearch(String aSearchString, boolean isFirewalled) {
        this(aSearchString, null, isFirewalled);
    }

    public KeywordSearch(String aSearchString, URN aSearchURN, boolean isFirewalled) {
        this.searchString = aSearchString;
        this.searchURN = aSearchURN;
        this.queryMsg = new QueryMsg(MessagePrefs.TTL.get().byteValue(), this.searchString, this.searchURN, false, isFirewalled);
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String aSearchString, boolean isFirewalled) {
        this.searchString = aSearchString;
        this.searchURN = null;
        this.queryMsg = new QueryMsg(MessagePrefs.TTL.get().byteValue(), this.searchString, this.searchURN, false, isFirewalled);
        this.fireSearchChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResponse(QueryResponseMsg msg) throws InvalidMessageException {
        if (!msg.getHeader().getMsgID().equals(this.queryMsg.getHeader().getMsgID())) {
            return;
        }
        QueryHitHost qhHost = QueryHitHost.createFrom(msg);
        QueryResponseRecord[] records = msg.getMsgRecords();
        ArrayList<RemoteFile> newHitList = new ArrayList<RemoteFile>(records.length);
        for (int i = 0; i < records.length; ++i) {
            if (this.searchURN != null && records[i].getURN() != null && !this.searchURN.equals(records[i].getURN()) || !this.isResponseRecordValid(records[i])) continue;
            KeywordSearch keywordSearch = this;
            synchronized (keywordSearch) {
                RemoteFile rfile;
                long fileSize = records[i].getFileSize();
                String filename = records[i].getFilename();
                URN urn = records[i].getURN();
                int fileIndex = records[i].getFileIndex();
                String metaData = records[i].getMetaData();
                short score = this.searchString == null ? (short)100 : (short)KeywordSearch.calculateSearchScore(this.searchString, filename);
                RemoteFile availableHit = this.searchResultHolder.findQueryHit(qhHost, urn, filename, fileSize, fileIndex);
                if (availableHit != null) {
                    availableHit.updateQueryHitHost(qhHost);
                    availableHit.setMetaData(metaData);
                } else {
                    String pathInfo = records[i].getPathInfo();
                    rfile = new RemoteFile(qhHost, fileIndex, filename, pathInfo, fileSize, urn, metaData, score);
                    this.searchResultHolder.addQueryHit(rfile);
                    newHitList.add(rfile);
                }
                DestAddress[] alternateLocations = records[i].getAlternateLocations();
                if (urn != null && alternateLocations != null) {
                    for (int j = 0; j < alternateLocations.length; ++j) {
                        QueryHitHost qhh = new QueryHitHost(null, alternateLocations[j], -1);
                        availableHit = this.searchResultHolder.findQueryHit(qhHost, urn, filename, fileSize, fileIndex);
                        if (availableHit != null) {
                            availableHit.updateQueryHitHost(qhHost);
                            availableHit.setMetaData(metaData);
                            continue;
                        }
                        rfile = new RemoteFile(qhh, -1, filename, "", fileSize, urn, metaData, score);
                        this.searchResultHolder.addQueryHit(rfile);
                        newHitList.add(rfile);
                    }
                }
                continue;
            }
        }
        if (newHitList.size() > 0) {
            if (this.queryEngine != null) {
                this.queryEngine.incrementResultCount(msg.getUniqueResultCount());
            }
            RemoteFile[] newHits = new RemoteFile[newHitList.size()];
            newHitList.toArray(newHits);
            this.fireSearchHitsAdded(newHits);
        }
    }

    public static short calculateSearchScore(String searchStr, String resultStr) {
        double tokenCount = 0.0;
        double hitCount = 0.0;
        StringTokenizer tokens = new StringTokenizer(searchStr);
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.setText(resultStr, false);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            tokenCount += 1.0;
            searchEngine.setPattern(token, false);
            if (!searchEngine.match()) continue;
            hitCount += 1.0;
        }
        double perc = hitCount / tokenCount * 100.0;
        return (short)perc;
    }

    public String toString() {
        return "[KeywordSearch:" + this.searchString + "," + super.toString() + "]";
    }
}

