/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.List;
import phex.common.ThreadTracking;
import phex.common.log.NLogger;
import phex.host.Host;
import phex.query.DynamicQueryEngine;

public class DynamicQueryWorker
implements Runnable {
    private static final int WORKER_SLEEP_TIME = 500;
    private List<DynamicQueryEngine> queryList = new ArrayList<DynamicQueryEngine>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDynamicQueryEngine(DynamicQueryEngine engine) {
        List<DynamicQueryEngine> list = this.queryList;
        synchronized (list) {
            this.queryList.add(engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDynamicQuerysForHost(Host host) {
        ArrayList<DynamicQueryEngine> removeList = new ArrayList<DynamicQueryEngine>();
        List<DynamicQueryEngine> list = this.queryList;
        synchronized (list) {
            for (DynamicQueryEngine queryEngine : this.queryList) {
                if (queryEngine.getFromHost() != host) continue;
                removeList.add(queryEngine);
            }
            this.queryList.removeAll(removeList);
        }
    }

    public void startQueryWorker() {
        Thread thread = new Thread(ThreadTracking.rootThreadGroup, this, "DynamicQueryWorker-" + Integer.toHexString(this.hashCode()));
        thread.setPriority(5);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException exp) {
                Thread.currentThread().interrupt();
            }
            try {
                this.processQueryList();
                continue;
            }
            catch (Throwable th) {
                NLogger.error(DynamicQueryWorker.class, (Object)th, th);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueryList() {
        DynamicQueryEngine[] queryEngines;
        List<DynamicQueryEngine> list = this.queryList;
        synchronized (list) {
            int size = this.queryList.size();
            if (size == 0) {
                return;
            }
            queryEngines = new DynamicQueryEngine[size];
            this.queryList.toArray(queryEngines);
        }
        for (int i = 0; i < queryEngines.length; ++i) {
            if (queryEngines[i].isQueryFinished()) {
                List<DynamicQueryEngine> list2 = this.queryList;
                synchronized (list2) {
                    this.queryList.remove(queryEngines[i]);
                    continue;
                }
            }
            queryEngines[i].processQuery();
        }
    }
}

