/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.common.URN;
import phex.common.log.NLogger;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.host.Host;
import phex.msg.InvalidMessageException;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.msghandling.MessageSubscriber;
import phex.prefs.core.ConnectionPrefs;
import phex.query.QueryHitHost;
import phex.security.AccessType;
import phex.security.PhexSecurityManager;

public class DownloadCandidateSnoop
implements MessageSubscriber<QueryResponseMsg> {
    private final SwarmingManager swarmingMgr;

    public DownloadCandidateSnoop(SwarmingManager swarmingMgr) {
        this.swarmingMgr = swarmingMgr;
    }

    @Override
    public void onMessage(QueryResponseMsg message, Host sourceHost) {
        if (!ConnectionPrefs.EnableQueryHitSnooping.get().booleanValue()) {
            return;
        }
        try {
            QueryResponseRecord[] records;
            QueryHitHost qhHost = null;
            for (QueryResponseRecord rec : records = message.getMsgRecords()) {
                SWDownloadFile swdlf;
                if (!this.isResponseRecordValid(rec) || (swdlf = this.swarmingMgr.getDownloadFile(rec.getFileSize(), rec.getURN())) == null) continue;
                if (qhHost == null) {
                    qhHost = QueryHitHost.createFrom(message);
                }
                RemoteFile rFile = new RemoteFile(qhHost, rec.getFileIndex(), rec.getFilename(), rec.getPathInfo(), rec.getFileSize(), rec.getURN(), rec.getMetaData(), -1);
                swdlf.addDownloadCandidate(rFile);
            }
        }
        catch (InvalidMessageException e) {
            return;
        }
    }

    private boolean isResponseRecordValid(QueryResponseRecord record) {
        PhexSecurityManager securityMgr = PhexSecurityManager.getInstance();
        URN urn = record.getURN();
        if (urn != null && securityMgr.controlUrnAccess(urn) != AccessType.ACCESS_GRANTED) {
            NLogger.debug(DownloadCandidateSnoop.class, (Object)("Record contains blocked URN: " + urn.getAsString()));
            return false;
        }
        return true;
    }
}

