/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.io.IOException;
import java.util.ArrayList;
import phex.common.ThreadPool;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.connection.BrowseHostConnection;
import phex.connection.BrowseHostException;
import phex.download.RemoteFile;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.query.QueryHitHost;
import phex.query.QueryManager;
import phex.query.Search;
import phex.servent.Servent;

public class BrowseHostResults
extends Search {
    private final Servent servent;
    private final DestAddress destAddress;
    private final GUID hostGUID;
    private BrowseHostStatus browseHostStatus;

    public BrowseHostResults(Servent servent, DestAddress hostAddress, GUID aHostGUID) {
        this.servent = servent;
        this.destAddress = hostAddress;
        this.hostGUID = aHostGUID;
        this.browseHostStatus = BrowseHostStatus.INITIALIZING;
    }

    public DestAddress getDestAddress() {
        return this.destAddress;
    }

    public GUID getHostGUID() {
        return this.hostGUID;
    }

    @Override
    public void startSearching(QueryManager queryService) {
        this.isSearching = true;
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                BrowseHostConnection connection = new BrowseHostConnection(BrowseHostResults.this.servent, BrowseHostResults.this.destAddress, BrowseHostResults.this.hostGUID, BrowseHostResults.this);
                try {
                    connection.sendBrowseHostRequest();
                    BrowseHostResults.this.browseHostStatus = BrowseHostStatus.FINISHED;
                }
                catch (BrowseHostException exp) {
                    NLogger.warn(BrowseHostResults.class, (Object)exp, (Throwable)exp);
                    BrowseHostResults.this.browseHostStatus = BrowseHostStatus.BROWSE_HOST_ERROR;
                    BrowseHostResults.this.stopSearching();
                }
                catch (IOException exp) {
                    NLogger.warn(BrowseHostResults.class, (Object)exp, (Throwable)exp);
                    BrowseHostResults.this.browseHostStatus = BrowseHostStatus.CONNECTION_ERROR;
                    BrowseHostResults.this.stopSearching();
                }
            }
        };
        ThreadPool.getInstance().addJob(runner, "BrowseHostConnection-" + Integer.toHexString(runner.hashCode()));
        this.fireSearchStarted();
    }

    public void setBrowseHostStatus(BrowseHostStatus status) {
        this.browseHostStatus = status;
    }

    public BrowseHostStatus getBrowseHostStatus() {
        return this.browseHostStatus;
    }

    @Override
    public void stopSearching() {
        this.isSearching = false;
        this.fireSearchStoped();
    }

    @Override
    public int getProgress() {
        switch (this.browseHostStatus) {
            case INITIALIZING: {
                return 0;
            }
            case CONNECTING: {
                return 10;
            }
            case FETCHING: {
                return 50;
            }
        }
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResponse(QueryResponseMsg msg) throws InvalidMessageException {
        QueryHitHost qhHost = QueryHitHost.createFrom(msg);
        QueryResponseRecord[] records = msg.getMsgRecords();
        ArrayList<RemoteFile> newHitList = new ArrayList<RemoteFile>(records.length);
        for (int i = 0; i < records.length; ++i) {
            if (!this.isResponseRecordValid(records[i])) continue;
            BrowseHostResults browseHostResults = this;
            synchronized (browseHostResults) {
                long fileSize = records[i].getFileSize();
                String filename = records[i].getFilename();
                URN urn = records[i].getURN();
                int fileIndex = records[i].getFileIndex();
                String metaData = records[i].getMetaData();
                String pathInfo = records[i].getPathInfo();
                RemoteFile rfile = new RemoteFile(qhHost, fileIndex, filename, pathInfo, fileSize, urn, metaData, 100);
                this.searchResultHolder.addQueryHit(rfile);
                newHitList.add(rfile);
                continue;
            }
        }
        if (newHitList.size() > 0) {
            if (this.queryEngine != null) {
                this.queryEngine.incrementResultCount(msg.getUniqueResultCount());
            }
            RemoteFile[] newHits = new RemoteFile[newHitList.size()];
            newHitList.toArray(newHits);
            this.fireSearchHitsAdded(newHits);
        }
    }

    public String toString() {
        return "[BrowseHostResults:" + this.destAddress + "," + "@" + Integer.toHexString(this.hashCode()) + "]";
    }

    public static enum BrowseHostStatus {
        INITIALIZING,
        CONNECTING,
        FETCHING,
        FINISHED,
        CONNECTION_ERROR,
        BROWSE_HOST_ERROR;

    }
}

