/*
 * Decompiled with CFR 0.152.
 */
package phex.prefs.core;

import phex.Res;
import phex.common.Environment;
import phex.prefs.OldCfg;
import phex.prefs.api.Preferences;
import phex.prefs.core.BandwidthPrefs;
import phex.prefs.core.ConnectionPrefs;
import phex.prefs.core.DownloadPrefs;
import phex.prefs.core.FilePrefs;
import phex.prefs.core.LibraryPrefs;
import phex.prefs.core.MessagePrefs;
import phex.prefs.core.NetworkPrefs;
import phex.prefs.core.ProxyPrefs;
import phex.prefs.core.SecurityPrefs;
import phex.prefs.core.StatisticPrefs;
import phex.prefs.core.SubscriptionPrefs;
import phex.prefs.core.UpdatePrefs;
import phex.prefs.core.UploadPrefs;
import phex.utils.StringUtils;

public class PhexCorePrefs
extends Preferences {
    protected static final PhexCorePrefs instance = new PhexCorePrefs();

    protected PhexCorePrefs() {
        super(Environment.getInstance().getPhexConfigFile("phexCorePrefs.properties"));
    }

    public static void init() {
        instance.load();
        instance.updatePreferences();
        StatisticPrefs.TotalStartupCounter.set(new Integer(StatisticPrefs.TotalStartupCounter.get() + 1));
    }

    public static void save(boolean force) {
        if (force) {
            instance.saveRequiredNotify();
        }
        instance.save();
    }

    public void updatePreferences() {
        if (StringUtils.isEmpty(UpdatePrefs.RunningBuildNumber.get())) {
            // empty if block
        }
        UpdatePrefs.RunningBuildNumber.set(Environment.getInstance().getProperty("build.number"));
        UpdatePrefs.RunningPhexVersion.set(Res.getStr("Program.Version"));
    }

    public static void updatePreV30Config(OldCfg cfg) {
        NetworkPrefs.ServentGuid.set(cfg.mProgramClientID.toHexString());
        NetworkPrefs.ListeningPort.set(new Integer(cfg.mListeningPort));
        NetworkPrefs.CurrentNetwork.set(cfg.mCurrentNetwork);
        NetworkPrefs.NetworkHistory.set(cfg.mNetNetworkHistory);
        NetworkPrefs.ConnectedToLAN.set(cfg.connectedToLAN);
        NetworkPrefs.TcpConnectTimeout.set(new Integer(cfg.socketConnectTimeout));
        NetworkPrefs.TcpRWTimeout.set(new Integer(cfg.socketRWTimeout));
        NetworkPrefs.MaxConcurrentConnectAttempts.set(cfg.maxConcurrentConnectAttempts);
        NetworkPrefs.MaxHostInHostCache.set(new Integer(cfg.mNetMaxHostToCatch));
        NetworkPrefs.AllowChatConnection.set(cfg.isChatEnabled);
        ConnectionPrefs.AutoConnectOnStartup.set(cfg.mAutoConnect);
        ConnectionPrefs.AllowToBecomeUP.set(cfg.allowToBecomeUP);
        ConnectionPrefs.ForceToBeUltrapeer.set(cfg.forceToBeUltrapeer);
        ConnectionPrefs.Up2UpConnections.set(cfg.up2upConnections);
        ConnectionPrefs.Up2LeafConnections.set(cfg.up2leafConnections);
        ConnectionPrefs.Leaf2UpConnections.set(cfg.leaf2upConnections);
        ConnectionPrefs.HasConnectedIncomming.set(cfg.hasConnectedIncomming);
        ConnectionPrefs.OfflineConnectionFailureCount.set(cfg.offlineConnectionFailureCount);
        ConnectionPrefs.EnableQueryHitSnooping.set(cfg.enableHitSnooping);
        ConnectionPrefs.AcceptDeflateConnection.set(cfg.isDeflateConnectionAccepted);
        MessagePrefs.MaxLength.set(new Integer(cfg.maxMessageLength));
        MessagePrefs.MaxNetworkTTL.set(new Integer(cfg.maxNetworkTTL));
        MessagePrefs.TTL.set(cfg.ttl);
        DownloadPrefs.DestinationDirectory.set(cfg.mDownloadDir);
        DownloadPrefs.IncompleteDirectory.set(cfg.incompleteDir);
        DownloadPrefs.MaxWorkerPerDownload.set(Integer.valueOf(cfg.maxWorkerPerDownload));
        DownloadPrefs.MaxTotalDownloadWorker.set(Integer.valueOf(cfg.maxTotalDownloadWorker));
        DownloadPrefs.MaxWriteBufferPerDownload.set(new Integer(cfg.maxWriteBufferPerDownload));
        DownloadPrefs.MaxTotalDownloadWriteBuffer.set(new Integer(cfg.maxTotalDownloadWriteBuffer));
        DownloadPrefs.MaxDownloadsPerIP.set(cfg.maxDownloadsPerIP);
        DownloadPrefs.SegmentInitialSize.set(new Integer(cfg.initialSegmentSize));
        DownloadPrefs.SegmentTransferTargetTime.set(new Integer(cfg.segmentTransferTime));
        DownloadPrefs.SegmentMaximumSize.set(new Integer(cfg.maximumSegmentSize));
        DownloadPrefs.SegmentMultiple.set(new Integer((int)cfg.segmentMultiple));
        DownloadPrefs.CandidateMinAllowedTransferRate.set(new Integer(cfg.minimumAllowedTransferRate));
        DownloadPrefs.CandidateLogBufferSize.set(new Integer((int)cfg.downloadCandidateLogBufferSize));
        DownloadPrefs.PushRequestTimeout.set(new Integer(cfg.mPushTransferTimeout));
        DownloadPrefs.AutoReadoutMagmaFiles.set(cfg.autoReadoutDownloadedMagma);
        DownloadPrefs.AutoReadoutMetalinkFiles.set(cfg.autoReadoutDownloadedMetalink);
        DownloadPrefs.AutoReadoutRSSFiles.set(cfg.autoReadoutDownloadedRSS);
        DownloadPrefs.AutoRemoveCompleted.set(cfg.mDownloadAutoRemoveCompleted);
        UploadPrefs.MaxParallelUploads.set(cfg.mMaxUpload);
        UploadPrefs.MaxUploadsPerIP.set(cfg.mMaxUploadPerIP);
        UploadPrefs.AutoRemoveCompleted.set(cfg.mUploadAutoRemoveCompleted);
        UploadPrefs.SharePartialFiles.set(cfg.arePartialFilesShared);
        UploadPrefs.AllowQueuing.set(cfg.allowUploadQueuing);
        UploadPrefs.MaxQueueSize.set(new Integer(cfg.maxUploadQueueSize));
        UploadPrefs.MinQueuePollTime.set(cfg.minUploadQueuePollTime);
        UploadPrefs.MaxQueuePollTime.set(cfg.maxUploadQueuePollTime);
        UploadPrefs.UploadStateLogBufferSize.set(new Integer((int)cfg.uploadStateLogBufferSize));
        BandwidthPrefs.NetworkSpeedKbps.set(new Integer(cfg.networkSpeedKbps));
        BandwidthPrefs.MaxTotalBandwidth.set(new Integer(cfg.maxTotalBandwidth));
        BandwidthPrefs.MaxNetworkBandwidth.set(new Integer(cfg.mNetMaxRate));
        BandwidthPrefs.MaxDownloadBandwidth.set(new Integer(cfg.mDownloadMaxBandwidth));
        BandwidthPrefs.MaxUploadBandwidth.set(new Integer(cfg.mUploadMaxBandwidth));
        LibraryPrefs.SharedDirectoriesSet.set(cfg.sharedDirectoriesSet);
        LibraryPrefs.LibraryExclusionRegExList.set(cfg.libraryExclusionRegExList);
        LibraryPrefs.UrnCalculationMode.set(Integer.valueOf(cfg.urnCalculationMode));
        LibraryPrefs.ThexCalculationMode.set(Integer.valueOf(cfg.thexCalculationMode));
        LibraryPrefs.AllowBrowsing.set(cfg.mShareBrowseDir);
        SecurityPrefs.FilteredPorts.set(cfg.filteredCatcherPorts);
        ProxyPrefs.ForcedIp.set(cfg.mMyIP);
        ProxyPrefs.UseSocks5.set(cfg.mProxyUse);
        ProxyPrefs.Socks5Host.set(new String(cfg.mProxyHost));
        ProxyPrefs.Socks5Port.set(new Integer(cfg.mProxyPort));
        ProxyPrefs.Socks5Authentication.set(cfg.useProxyAuthentication);
        ProxyPrefs.Socks5User.set(new String(cfg.mProxyUserName));
        ProxyPrefs.Socks5Password.set(new String(cfg.mProxyPassword));
        ProxyPrefs.UseHttp.set(cfg.isHttpProxyUsed);
        ProxyPrefs.HttpHost.set(new String(cfg.httpProxyHost));
        ProxyPrefs.HttpPort.set(new Integer(cfg.httpProxyPort));
        StatisticPrefs.FractionalUptime.set(new Float(cfg.fractionalUptime));
        StatisticPrefs.LastShutdownTime.set(new Long(cfg.lastShutdownTime));
        StatisticPrefs.MaximalUptime.set(new Long(cfg.maximalUptime));
        StatisticPrefs.MovingTotalUptime.set(new Long(cfg.movingTotalUptime));
        StatisticPrefs.MovingTotalUptimeCount.set(new Integer(cfg.movingTotalUptimeCount));
        StatisticPrefs.TotalDownloadCount.set(cfg.totalDownloadCount);
        StatisticPrefs.TotalStartupCounter.set(cfg.totalStartupCounter);
        StatisticPrefs.TotalUploadCount.set(cfg.totalUploadCount);
        UpdatePrefs.LastUpdateCheckVersion.set(cfg.lastUpdateCheckVersion);
        UpdatePrefs.LastBetaUpdateCheckVersion.set(cfg.lastBetaUpdateCheckVersion);
        UpdatePrefs.LastUpdateCheckTime.set(new Long(cfg.lastUpdateCheckTime));
        UpdatePrefs.LastShownUpdateInfoId.set(new Integer(cfg.lastShownUpdateInfoId));
        FilePrefs.OpenFilesLimit.set(cfg.openFilesLimit);
        SubscriptionPrefs.DownloadSilently.set(cfg.downloadSubscriptionsSilently);
        SubscriptionPrefs.SubscriptionMagnets.set(cfg.subscriptionMagnets);
    }
}

