/*
 * Decompiled with CFR 0.152.
 */
package phex.prefs.api;

import phex.prefs.api.Preferences;

public class Setting<T> {
    protected final Preferences preferences;
    protected final String name;
    protected T value;
    protected final T defaultValue;
    protected boolean isAlwaysSaved;

    protected Setting(String name, T value, T defaultValue, Preferences preferences) {
        this.preferences = preferences;
        this.name = name;
        this.value = value;
        this.defaultValue = defaultValue;
        this.isAlwaysSaved = false;
    }

    public boolean isAlwaysSaved() {
        return this.isAlwaysSaved;
    }

    public void setAlwaysSaved(boolean isAlwaysSaved) {
        this.isAlwaysSaved = isAlwaysSaved;
    }

    public void set(T newValue) {
        if (!(this.value != null ? this.value.equals(newValue) : newValue == null)) {
            this.value = newValue;
            this.preferences.saveRequiredNotify();
        }
    }

    public void changed() {
        this.preferences.saveRequiredNotify();
    }

    public T get() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefault() {
        if (this.value == this.defaultValue) {
            return true;
        }
        if (this.value == null || this.defaultValue == null) {
            return false;
        }
        return this.value.equals(this.defaultValue);
    }
}

