/*
 * Decompiled with CFR 0.152.
 */
package phex.prefs.api;

import phex.prefs.api.Preferences;
import phex.prefs.api.Setting;

public class RangeSetting<T extends Comparable<T>>
extends Setting<T> {
    protected final T minValue;
    protected final T maxValue;

    public RangeSetting(String key, T value, T defaultValue, T minValue, T maxValue, Preferences preferences) {
        super(key, value, defaultValue, preferences);
        if (maxValue == null || minValue == null) {
            throw new NullPointerException("Min or max value is null");
        }
        if (maxValue.compareTo(minValue) < 0) {
            throw new IllegalArgumentException("Max less then min.");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public T max() {
        return this.maxValue;
    }

    @Override
    public void set(T newValue) {
        if (newValue.compareTo(this.maxValue) > 0) {
            super.set(this.maxValue);
        } else if (newValue.compareTo(this.minValue) < 0) {
            super.set(this.minValue);
        } else {
            super.set(newValue);
        }
    }
}

