/*
 * Decompiled with CFR 0.152.
 */
package phex.net.repres.i2p;

import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.ByteChannel;
import net.i2p.client.streaming.I2PSocket;
import phex.common.address.DestAddress;
import phex.common.address.I2PDestAddress;
import phex.io.channels.StreamingByteChannel;
import phex.net.repres.SocketFacade;

public class I2PSocketFacade
implements SocketFacade {
    private I2PSocket socket;
    private StreamingByteChannel channel;
    private DestAddress remoteAddress;

    public I2PSocketFacade(I2PSocket aSocket) {
        this.socket = aSocket;
    }

    @Override
    public void setSoTimeout(int socketRWTimeout) throws SocketException {
        this.socket.setReadTimeout((long)socketRWTimeout);
    }

    @Override
    public ByteChannel getChannel() throws IOException {
        if (this.channel == null) {
            this.channel = new StreamingByteChannel(this.socket.getInputStream(), this.socket.getOutputStream());
        }
        return this.channel;
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public DestAddress getRemoteAddress() {
        if (this.remoteAddress == null) {
            this.remoteAddress = new I2PDestAddress(this.socket.getPeerDestination());
        }
        return this.remoteAddress;
    }
}

