/*
 * Decompiled with CFR 0.152.
 */
package phex.net.repres.i2p;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import net.i2p.I2PException;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.client.streaming.I2PSocketManagerFull;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import phex.common.address.DestAddress;
import phex.common.address.I2PDestAddress;
import phex.common.address.IpAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.log.NLogger;
import phex.net.repres.PresentationManager;
import phex.net.repres.SocketFacade;
import phex.net.repres.i2p.I2PSocketFacade;
import phex.prefs.core.I2PPrefs;
import phex.utils.SystemProperties;

public class I2PPresentationManager
extends PresentationManager {
    public static final int INVALID_PORT = -1;
    private static String I2P_KEYFILE_NAME = "i2phex.key";
    protected I2PSocketManager socketManager;

    @Override
    public SocketFacade createSocket(DestAddress address, int connectTimeout) throws IOException {
        try {
            I2PSocket socket = this.socketManager.connect(new Destination(address.getHostName()));
            return new I2PSocketFacade(socket);
        }
        catch (DataFormatException e) {
            throw new IOException("Failed creating I2PSocketFacade, DataFormatException.");
        }
        catch (I2PException e) {
            throw new IOException("Failed creating I2PSocketFacade, I2PException.");
        }
    }

    @Override
    public boolean initialize() {
        File keyFile;
        try {
            keyFile = new File(SystemProperties.getPhexConfigRoot(), I2P_KEYFILE_NAME);
            if (!keyFile.exists()) {
                I2PClientFactory.createClient().createDestination((OutputStream)new FileOutputStream(keyFile));
            }
        }
        catch (Exception e) {
            NLogger.error(I2PPresentationManager.class, (Object)"Failed checking/creating I2P keyfile!");
            return false;
        }
        try {
            Properties p = new Properties();
            p.setProperty("i2p.streaming.manager", I2PSocketManagerFull.class.getName());
            p.setProperty("inbound.length", I2PPrefs.InboundLength.get().toString());
            p.setProperty("outbound.length", I2PPrefs.OutboundLength.get().toString());
            p.setProperty("inbound.lengthVariance", I2PPrefs.InboundLengthVariance.get().toString());
            p.setProperty("outbound.lengthVariance", I2PPrefs.OutboundLengthVariance.get().toString());
            p.setProperty("inbound.quantity", I2PPrefs.InboundQuantity.get().toString());
            p.setProperty("outbound.quantity", I2PPrefs.OutboundQuantity.get().toString());
            p.setProperty("inbound.backupQuantity", I2PPrefs.InboundBackupQuantity.get().toString());
            p.setProperty("outbound.backupQuantity", I2PPrefs.OutboundBackupQuantity.get().toString());
            p.setProperty("inbound.nickname", I2PPrefs.InboundNickname.get());
            p.setProperty("outbound.nickname", I2PPrefs.OutboundNickname.get());
            this.socketManager = I2PSocketManagerFactory.createManager((InputStream)new FileInputStream(keyFile), (String)I2PPrefs.I2CPHost.get().toString(), (int)I2PPrefs.I2CPPort.get(), (Properties)p);
            if (this.socketManager == null) {
                NLogger.error(I2PPresentationManager.class, (Object)"Got a null socket manager, I2P router unreachable!");
                return false;
            }
        }
        catch (FileNotFoundException e) {
            NLogger.error(I2PPresentationManager.class, (Object)"Failed reading I2P keyfile!");
            return false;
        }
        return true;
    }

    @Override
    public I2PSocketManager getSocketManager() {
        return this.socketManager;
    }

    @Override
    public DestAddress createHostAddress(String address, int defaultPort) throws MalformedDestAddressException {
        I2PDestAddress destAddress = null;
        try {
            destAddress = new I2PDestAddress(address, -1);
        }
        catch (NullPointerException e) {
            throw new MalformedDestAddressException("Malformed destination address.");
        }
        return destAddress;
    }

    @Override
    public DestAddress createHostAddress(IpAddress ipAddress, int port) {
        return null;
    }

    @Override
    public DestAddress createHostAddress(byte[] aHostIP, int aPort) {
        return null;
    }
}

