/*
 * Decompiled with CFR 0.152.
 */
package phex.net.repres.def;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import phex.common.address.AddressUtils;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.address.MalformedDestAddressException;
import phex.net.repres.PresentationManager;
import phex.net.repres.SocketFacade;
import phex.net.repres.def.DefaultSocketFacade;

public class DefaultPresentationManager
extends PresentationManager {
    @Override
    public SocketFacade createSocket(DestAddress address, int connectTimeout) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(address.getHostName(), address.getPort()), connectTimeout);
        return new DefaultSocketFacade(socket);
    }

    @Override
    public DestAddress createHostAddress(String address, int defaultPort) throws MalformedDestAddressException {
        int port;
        String hostName;
        int idx = address.indexOf(58);
        if (idx == 0) {
            throw new MalformedDestAddressException("No host name: " + address);
        }
        if (idx < 0) {
            hostName = address;
            port = 6346;
        } else {
            hostName = address.substring(0, idx);
            port = AddressUtils.parsePort(address);
            if (port < 0) {
                throw new MalformedDestAddressException("Invalid port: " + address);
            }
        }
        DefaultDestAddress hostAddress = new DefaultDestAddress(hostName, port);
        return hostAddress;
    }

    @Override
    public DestAddress createHostAddress(IpAddress ipAddress, int port) {
        DefaultDestAddress destAddress = new DefaultDestAddress(ipAddress, port);
        return destAddress;
    }

    @Override
    public DestAddress createHostAddress(byte[] aHostIP, int aPort) {
        DefaultDestAddress destAddress = new DefaultDestAddress(aHostIP, aPort);
        return destAddress;
    }
}

