/*
 * Decompiled with CFR 0.152.
 */
package phex.net;

import java.io.IOException;
import java.util.TimerTask;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.Environment;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.address.LocalServentAddress;
import phex.common.log.NLogger;
import phex.event.ChangeEvent;
import phex.host.NetworkHostsContainer;
import phex.prefs.core.ConnectionPrefs;
import phex.prefs.core.NetworkPrefs;
import phex.servent.Servent;

public abstract class Server
implements Runnable {
    private FirewallCheckTimer firewallCheckTimer;
    protected LocalServentAddress localAddress;
    protected volatile boolean isRunning = false;
    protected boolean hasConnectedIncomming = ConnectionPrefs.HasConnectedIncomming.get();
    protected long lastInConnectionTime = -1L;
    protected static final int INVALID_PORT = -1;

    public Server() {
        this.localAddress = new LocalServentAddress(this);
    }

    public synchronized void startup() throws IOException {
        if (this.isRunning) {
            return;
        }
        NLogger.debug(Server.class, (Object)"Starting listener");
        this.isRunning = true;
        this.firewallCheckTimer = new FirewallCheckTimer();
        Environment.getInstance().scheduleTimerTask(this.firewallCheckTimer, 300000L, 300000L);
        this.bind(NetworkPrefs.ListeningPort.get());
        ThreadPool.getInstance().addJob(this, "IncommingListener-" + Integer.toHexString(this.hashCode()));
    }

    protected abstract void bind(int var1) throws IOException;

    protected abstract void closeServer();

    public synchronized void restart() throws IOException {
        this.shutdown(true);
        this.startup();
    }

    public synchronized void shutdown(boolean waitForCompleted) {
        if (!this.isRunning) {
            return;
        }
        NLogger.debug(Server.class, (Object)"Shutting down listener");
        this.firewallCheckTimer.cancel();
        this.firewallCheckTimer = null;
        ConnectionPrefs.HasConnectedIncomming.set(new Boolean(this.hasConnectedIncomming));
        this.closeServer();
        if (waitForCompleted) {
            while (this.isRunning) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean hasConnectedIncoming() {
        return this.hasConnectedIncomming;
    }

    public IpAddress resolveLocalHostIP() {
        return null;
    }

    public LocalServentAddress getLocalAddress() {
        return this.localAddress;
    }

    public void updateLocalAddress(DestAddress newAddress) {
        this.localAddress.updateLocalAddress(newAddress);
    }

    public int getListeningLocalPort() {
        return -1;
    }

    private class IncommingCheckRunner
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private IncommingCheckRunner() {
        }

        @Override
        public void run() {
            Server.this.hasConnectedIncomming = true;
        }
    }

    public class FirewallCheckTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 300000L;
        private static final long CHECK_TIME = 1800000L;
        private long lastFirewallCheckTime;
        private final NetworkHostsContainer netHostsContainer = Servent.getInstance().getHostService().getNetworkHostsContainer();

        FirewallCheckTimer() {
            Servent.getInstance().getEventService().processAnnotations(this);
        }

        @Override
        public void run() {
            try {
                long now;
                this.lastFirewallCheckTime = now = System.currentTimeMillis();
            }
            catch (Throwable th) {
                NLogger.error(Server.class, (Object)th, th);
            }
        }

        @EventTopicSubscriber(topic="phex:servent/localAddress")
        public void onLocaleAddressEvent(String topic, ChangeEvent event) {
            this.lastFirewallCheckTime = 0L;
        }
    }
}

