/*
 * Decompiled with CFR 0.152.
 */
package phex.net;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import phex.common.Environment;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.log.NLogger;
import phex.connection.IncomingConnectionDispatcher;
import phex.host.NetworkHostsContainer;
import phex.net.Server;
import phex.net.repres.PresentationManager;
import phex.net.repres.SocketFacade;
import phex.net.repres.def.DefaultSocketFacade;
import phex.prefs.core.NetworkPrefs;
import phex.security.AccessType;
import phex.security.PhexSecurityException;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;

public class OIOServer
extends Server {
    protected ServerSocket serverSocket;

    public OIOServer() {
        Environment.getInstance().scheduleTimerTask(new Server.FirewallCheckTimer(this), 300000L, 300000L);
    }

    @Override
    public int getListeningLocalPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return NetworkPrefs.ListeningPort.get();
    }

    @Override
    public IpAddress resolveLocalHostIP() {
        byte[] ip = null;
        InetAddress addr = this.serverSocket.getInetAddress();
        ip = addr.getAddress();
        if (ip[0] == 0 && ip[1] == 0 && ip[2] == 0 && ip[3] == 0) {
            ip = IpAddress.LOCAL_HOST_IP;
        }
        IpAddress ipAddress = new IpAddress(ip);
        return ipAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (NLogger.isDebugEnabled(OIOServer.class)) {
            NLogger.debug(OIOServer.class, (Object)("Listener started. Listening on: " + this.serverSocket.getInetAddress().getHostAddress() + ':' + this.serverSocket.getLocalPort()));
        }
        try {
            while (this.serverSocket != null && !this.serverSocket.isClosed()) {
                try {
                    Socket incoming = this.serverSocket.accept();
                    DefaultSocketFacade incomingFacade = new DefaultSocketFacade(incoming);
                    this.handleIncomingSocket(incomingFacade);
                }
                catch (SocketException exp) {
                    NLogger.debug(OIOServer.class, (Object)exp);
                }
                catch (PhexSecurityException exp) {
                    NLogger.debug(OIOServer.class, (Object)exp);
                }
                catch (IOException exp) {
                    NLogger.error(OIOServer.class, (Object)exp, (Throwable)exp);
                }
            }
        }
        catch (Exception exp) {
            NLogger.error(OIOServer.class, (Object)exp, (Throwable)exp);
        }
        this.isRunning = false;
        NLogger.debug(OIOServer.class, (Object)"Listener stopped.");
        DestAddress newAddress = PresentationManager.getInstance().createHostAddress(new IpAddress(IpAddress.LOCAL_HOST_IP), 6346);
        this.localAddress.updateLocalAddress(newAddress);
        OIOServer oIOServer = this;
        synchronized (oIOServer) {
            this.notifyAll();
        }
    }

    private void handleIncomingSocket(SocketFacade clientSocket) throws IOException, PhexSecurityException {
        clientSocket.setSoTimeout(NetworkPrefs.TcpRWTimeout.get());
        DestAddress address = clientSocket.getRemoteAddress();
        NetworkHostsContainer netHostsContainer = Servent.getInstance().getHostService().getNetworkHostsContainer();
        IpAddress remoteIp = address.getIpAddress();
        assert (remoteIp != null);
        if (!netHostsContainer.isConnectedToHost(address) && !remoteIp.isSiteLocalIP()) {
            this.hasConnectedIncomming = true;
            this.lastInConnectionTime = System.currentTimeMillis();
        }
        AccessType access = PhexSecurityManager.getInstance().controlHostAddressAccess(address);
        switch (access) {
            case ACCESS_DENIED: 
            case ACCESS_STRONGLY_DENIED: {
                throw new PhexSecurityException("Host access denied: " + address);
            }
        }
        NLogger.debug(OIOServer.class, (Object)("Accepted incoming connection from: " + address.getFullHostName()));
        IncomingConnectionDispatcher dispatcher = new IncomingConnectionDispatcher(clientSocket, Servent.getInstance());
        ThreadPool.getInstance().addJob(dispatcher, "IncomingConnectionDispatcher-" + Integer.toHexString(this.hashCode()));
    }

    @Override
    protected synchronized void bind(int initialPort) throws IOException {
        boolean error;
        assert (this.serverSocket == null);
        this.serverSocket = new ServerSocket();
        int tries = 0;
        do {
            error = false;
            try {
                NLogger.debug(OIOServer.class, (Object)("Binding to port " + initialPort));
                this.serverSocket.bind(new InetSocketAddress(initialPort));
            }
            catch (BindException exp) {
                NLogger.debug(OIOServer.class, (Object)("Binding failed to port " + initialPort));
                if (tries > 50) {
                    throw exp;
                }
                error = true;
                ++initialPort;
                ++tries;
            }
        } while (error);
        IpAddress hostIP = this.resolveLocalHostIP();
        initialPort = this.serverSocket.getLocalPort();
        DestAddress newAddress = PresentationManager.getInstance().createHostAddress(hostIP, initialPort);
        this.localAddress.updateLocalAddress(newAddress);
    }

    @Override
    protected synchronized void closeServer() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverSocket = null;
        }
    }
}

