/*
 * Decompiled with CFR 0.152.
 */
package phex.net;

import java.io.IOException;
import java.net.SocketException;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.log.NLogger;
import phex.connection.IncomingConnectionDispatcher;
import phex.host.NetworkHostsContainer;
import phex.net.Server;
import phex.net.repres.PresentationManager;
import phex.net.repres.SocketFacade;
import phex.net.repres.i2p.I2PSocketFacade;
import phex.prefs.core.NetworkPrefs;
import phex.security.AccessType;
import phex.security.PhexSecurityException;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;

public class I2PServer
extends Server {
    protected I2PSocketManager socketManager;
    protected I2PServerSocket serverSocket;

    @Override
    public int getListeningLocalPort() {
        return -1;
    }

    @Override
    public IpAddress resolveLocalHostIP() {
        return null;
    }

    public void resetFirewallCheck() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (NLogger.isDebugEnabled(I2PServer.class)) {
            NLogger.debug(I2PServer.class, (Object)("I2P server listening on: " + this.socketManager.getSession().getMyDestination().toBase64()));
        }
        try {
            while (this.serverSocket != null) {
                try {
                    I2PSocket incoming = this.serverSocket.accept();
                    I2PSocketFacade incomingFacade = new I2PSocketFacade(incoming);
                    this.handleIncomingSocket(incomingFacade);
                }
                catch (SocketException exp) {
                    NLogger.debug(I2PServer.class, (Object)exp);
                }
                catch (PhexSecurityException exp) {
                    NLogger.debug(I2PServer.class, (Object)exp);
                }
                catch (IOException exp) {
                    NLogger.error(I2PServer.class, (Object)exp, (Throwable)exp);
                }
            }
        }
        catch (Exception exp) {
            NLogger.error(I2PServer.class, (Object)exp, (Throwable)exp);
        }
        this.isRunning = false;
        NLogger.debug(I2PServer.class, (Object)"I2P listener stopped.");
        DestAddress address = null;
        this.localAddress.updateLocalAddress(address);
        I2PServer i2PServer = this;
        synchronized (i2PServer) {
            this.notifyAll();
        }
    }

    private void handleIncomingSocket(SocketFacade clientSocket) throws IOException, PhexSecurityException {
        clientSocket.setSoTimeout(NetworkPrefs.TcpRWTimeout.get());
        DestAddress address = clientSocket.getRemoteAddress();
        NetworkHostsContainer netHostsContainer = Servent.getInstance().getHostService().getNetworkHostsContainer();
        assert (address != null);
        if (!netHostsContainer.isConnectedToHost(address)) {
            this.hasConnectedIncomming = true;
            this.lastInConnectionTime = System.currentTimeMillis();
        }
        AccessType access = PhexSecurityManager.getInstance().controlHostAddressAccess(address);
        switch (access) {
            case ACCESS_DENIED: 
            case ACCESS_STRONGLY_DENIED: {
                throw new PhexSecurityException("Host access denied: " + address);
            }
        }
        NLogger.debug(I2PServer.class, (Object)("Accepted incoming connection from: " + address.getFullHostName()));
        IncomingConnectionDispatcher dispatcher = new IncomingConnectionDispatcher(clientSocket, Servent.getInstance());
        ThreadPool.getInstance().addJob(dispatcher, "IncomingConnectionDispatcher-" + Integer.toHexString(this.hashCode()));
    }

    @Override
    protected synchronized void bind(int initialPort) throws IOException {
        assert (this.serverSocket == null);
        this.socketManager = PresentationManager.getInstance().getSocketManager();
        this.serverSocket = this.socketManager.getServerSocket();
        if (this.serverSocket == null) {
            NLogger.debug(I2PServer.class, (Object)"Got a null I2PServerSocket, something is wrong!");
            throw new IOException("Got a null I2PServerSocket, something is wrong!");
        }
        try {
            DestAddress address = PresentationManager.getInstance().createHostAddress(this.socketManager.getSession().getMyDestination().toBase64(), -1);
            this.localAddress.updateLocalAddress(address);
        }
        catch (MalformedDestAddressException e) {
            NLogger.debug(I2PServer.class, (Object)"Failed creating local DestAddress!");
            throw new IOException("Failed creating local DestAddress!");
        }
    }

    @Override
    protected synchronized void closeServer() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.serverSocket = null;
        }
    }
}

