/*
 * Decompiled with CFR 0.152.
 */
package phex.msghandling;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import phex.host.Host;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msghandling.MessageSubscriber;

public class MessageSubscriberList<E extends Message>
implements MessageSubscriber<E> {
    private List<MessageSubscriber<E>> subscriberList = new CopyOnWriteArrayList<MessageSubscriber<E>>();

    MessageSubscriberList() {
    }

    MessageSubscriberList(MessageSubscriber<E> subscriber1, MessageSubscriber<E> subscriber2) {
        this();
        this.addSubscribers(subscriber1, subscriber2);
    }

    @Override
    public void onMessage(E message, Host sourceHost) throws InvalidMessageException {
        for (MessageSubscriber<E> messageSubscriber : this.subscriberList) {
            messageSubscriber.onMessage(message, sourceHost);
        }
    }

    public void addSubscriber(MessageSubscriber<E> subscriber) {
        this.subscriberList.add(subscriber);
    }

    public void addSubscribers(MessageSubscriber<E> ... subscriberArr) {
        this.subscriberList.addAll(Arrays.asList(subscriberArr));
    }

    public void removeSubscriber(MessageSubscriber<E> subscriber) {
        this.subscriberList.remove(subscriber);
    }
}

