/*
 * Decompiled with CFR 0.152.
 */
package phex.msg.vendor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import phex.common.log.NLogger;
import phex.msg.InvalidMessageException;
import phex.msg.MsgHeader;
import phex.msg.vendor.VendorMsg;
import phex.utils.IOUtil;

public class CapabilitiesVMsg
extends VendorMsg {
    private static final int VERSION = 0;
    private static final byte[] FEATURE_SEARCH_BYTES = new byte[]{87, 72, 65, 84};
    private static final int FEATURE_SEARCH_VERSION = 1;
    private static CapabilitiesVMsg myCapavilitiesVMsg;
    private final Set<SupportedCapability> capabilitiesSet;

    public CapabilitiesVMsg(MsgHeader header, byte[] vendorId, int subSelector, int version, byte[] data) throws InvalidMessageException {
        super(header, vendorId, subSelector, version, data);
        if (version > 0) {
            throw new InvalidMessageException("Vendor Message 'MessagesSupported' with invalid version: " + version);
        }
        this.capabilitiesSet = new HashSet<SupportedCapability>();
        try {
            ByteArrayInputStream dataStream = new ByteArrayInputStream(data);
            int itemCount = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(dataStream));
            byte[] itemBytes = new byte[6];
            for (int i = 0; i < itemCount; ++i) {
                dataStream.read(itemBytes);
                SupportedCapability supportedCapability = new SupportedCapability(itemBytes);
                this.capabilitiesSet.add(supportedCapability);
            }
        }
        catch (IOException exp) {
            NLogger.error(CapabilitiesVMsg.class, (Object)exp, (Throwable)exp);
            throw new InvalidMessageException(exp.getMessage());
        }
    }

    private CapabilitiesVMsg() {
        super(VENDORID_NULL, 10, 0, IOUtil.EMPTY_BYTE_ARRAY);
        this.capabilitiesSet = new HashSet<SupportedCapability>();
        this.createCapabilitiesMsgData();
    }

    public boolean isCapabilitySupported(byte[] capabilityName) {
        for (SupportedCapability cap : this.capabilitiesSet) {
            if (!Arrays.equals(capabilityName, cap.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isFeatureSearchSupported() {
        return this.isCapabilitySupported(FEATURE_SEARCH_BYTES);
    }

    public static CapabilitiesVMsg getMyCapabilitiesVMsg() {
        if (myCapavilitiesVMsg == null) {
            myCapavilitiesVMsg = new CapabilitiesVMsg();
        }
        return myCapavilitiesVMsg;
    }

    private void createCapabilitiesMsgData() {
        SupportedCapability featureCap = null;
        featureCap = new SupportedCapability(FEATURE_SEARCH_BYTES, 1);
        this.capabilitiesSet.add(featureCap);
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            IOUtil.serializeShortLE((short)this.capabilitiesSet.size(), outStream);
            for (SupportedCapability cap : this.capabilitiesSet) {
                cap.serialize(outStream);
            }
            byte[] data = outStream.toByteArray();
            this.setVenderMsgData(data);
        }
        catch (IOException exp) {
            NLogger.error(CapabilitiesVMsg.class, (Object)exp, (Throwable)exp);
        }
    }

    private static class SupportedCapability {
        private byte[] name;
        private int version;
        private int hashCode = -1;

        public SupportedCapability(byte[] name, int version) {
            this.name = name;
            this.version = version;
        }

        public SupportedCapability(byte[] itemBytes) throws InvalidMessageException {
            if (itemBytes.length < 6) {
                throw new InvalidMessageException("Invalid capability data.");
            }
            this.name = new byte[4];
            System.arraycopy(itemBytes, 0, this.name, 0, 4);
            this.version = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(itemBytes, 4));
        }

        public void serialize(OutputStream outStream) throws IOException {
            outStream.write(this.name);
            IOUtil.serializeShortLE((short)this.version, outStream);
        }

        public byte[] getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SupportedCapability) {
                SupportedCapability cap = (SupportedCapability)obj;
                return this.version == cap.version && Arrays.equals(this.name, cap.name);
            }
            return false;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                int code = 37 * this.version;
                for (int i = 0; i < this.name.length; ++i) {
                    code += 37 * this.name[i];
                }
                this.hashCode = code;
            }
            return this.hashCode;
        }

        public String toString() {
            return new String(this.name) + "/" + this.version;
        }
    }
}

