/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.io.buffer.ByteBuffer;
import phex.msg.GUID;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.net.repres.PresentationManager;
import phex.utils.IOUtil;

public class PushRequestMsg
extends Message {
    private byte[] body;
    private GUID clientGUID;
    private long fileIndex;
    private DestAddress requestAddress;

    public PushRequestMsg(MsgHeader aHeader, byte[] payload) {
        super(aHeader);
        this.getHeader().setPayloadType((byte)64);
        this.body = payload;
        this.getHeader().setDataLength(this.body.length);
        this.parseBody();
    }

    public PushRequestMsg(GUID aClientGUID, long aFileIndex, DestAddress aAddress) {
        super(new MsgHeader(64, 0));
        if (aAddress.getIpAddress() == null) {
            throw new IllegalArgumentException("Push request address must have IP.");
        }
        this.clientGUID = aClientGUID;
        this.fileIndex = aFileIndex;
        this.requestAddress = aAddress;
        this.buildBody();
        this.getHeader().setDataLength(this.body.length);
    }

    public GUID getClientGUID() {
        return this.clientGUID;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public DestAddress getRequestAddress() {
        return this.requestAddress;
    }

    @Override
    public ByteBuffer createMessageBuffer() {
        return ByteBuffer.wrap(this.body);
    }

    public String toString() {
        return "[" + this.getHeader() + " " + "ClientGUID=" + this.clientGUID + ", " + "FileIndex=" + this.fileIndex + ", " + "RequestAddress=" + this.requestAddress + ", " + "]";
    }

    private void buildBody() {
        this.body = new byte[26];
        this.clientGUID.serialize(this.body, 0);
        IOUtil.serializeIntLE((int)this.fileIndex, this.body, 16);
        IpAddress ip = this.requestAddress.getIpAddress();
        System.arraycopy(ip.getHostIP(), 0, this.body, 20, 4);
        IOUtil.serializeShortLE((short)this.requestAddress.getPort(), this.body, 24);
    }

    private void parseBody() {
        if (this.clientGUID == null) {
            this.clientGUID = new GUID();
        }
        this.clientGUID.deserialize(this.body, 0);
        this.fileIndex = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(this.body, 16));
        byte[] ip = new byte[]{this.body[20], this.body[21], this.body[22], this.body[23]};
        short port = IOUtil.deserializeShortLE(this.body, 24);
        this.requestAddress = PresentationManager.getInstance().createHostAddress(ip, (int)port);
    }
}

