/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.util.HashSet;
import java.util.Set;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.log.NLogger;
import phex.io.buffer.ByteBuffer;
import phex.msg.GGEPBlock;
import phex.msg.InvalidGGEPBlockException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.net.repres.PresentationManager;
import phex.security.AccessType;
import phex.security.PhexSecurityManager;
import phex.udp.hostcache.UdpHostCache;
import phex.utils.HexConverter;
import phex.utils.IOUtil;

public class PongMsg
extends Message {
    protected static final int MIN_PONG_DATA_LEN = 14;
    private byte[] body;
    private DestAddress pongAddress;
    private long fileCount;
    private long fileSizeInKB;
    private String vendor;
    private int vendorVersionMajor = -1;
    private int vendorVersionMinor = -1;
    private int avgDailyUptime;
    private boolean isUltrapeer;
    private GGEPBlock ggepBlock;
    private Set<DestAddress> ippDestAddresses;
    private Set<UdpHostCache> udpHostCaches;
    private UdpHostCache udpHostCache;
    private static int I2P_DEST_LENGTH = 516;
    private static int NULL_TERM_LENGTH = 1;
    private static int PORT_LENGTH = 1;
    private static int IP_LENGTH = 4;
    private static int FILECOUNT_LENGTH = 4;
    private static int FILESIZE_LENGTH = 4;

    public PongMsg(MsgHeader aHeader, byte[] payload) {
        super(aHeader);
        this.getHeader().setPayloadType((byte)1);
        this.body = payload;
        this.getHeader().setDataLength(this.body.length);
        this.avgDailyUptime = -1;
        this.parseBody();
    }

    protected PongMsg(MsgHeader header, DestAddress pongAddress, int fileCount, int fileSizeInKB, boolean isUltrapeer, GGEPBlock ggepBlock) {
        super(header);
        this.getHeader().setPayloadType((byte)1);
        this.pongAddress = pongAddress;
        this.fileCount = fileCount;
        this.isUltrapeer = isUltrapeer;
        this.ggepBlock = ggepBlock;
        this.fileSizeInKB = isUltrapeer ? (long)PongMsg.createUltrapeerMarking(fileSizeInKB) : (long)fileSizeInKB;
        this.buildBody();
        this.getHeader().setDataLength(this.body.length);
    }

    public DestAddress getPongAddress() {
        return this.pongAddress;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public long getFileSizeInKB() {
        return this.fileSizeInKB;
    }

    public String getVendor() {
        return this.vendor;
    }

    public int getVendorVersionMajor() {
        return this.vendorVersionMajor;
    }

    public int getVendorVersionMinor() {
        return this.vendorVersionMinor;
    }

    public int getDailyUptime() {
        return this.avgDailyUptime;
    }

    public boolean hasFreeLeafSlots() {
        if (this.ggepBlock == null || !this.ggepBlock.isExtensionAvailable("UP")) {
            return false;
        }
        byte[] data = this.ggepBlock.getExtensionData("UP");
        return data != null && data.length >= 3 && data[1] > 0;
    }

    public boolean hasFreeUPSlots() {
        if (this.ggepBlock == null || !this.ggepBlock.isExtensionAvailable("UP")) {
            return false;
        }
        byte[] data = this.ggepBlock.getExtensionData("UP");
        return data != null && data.length >= 3 && data[2] > 0;
    }

    public Set<DestAddress> getIPPDestAddresses() {
        return this.ippDestAddresses;
    }

    public Set<UdpHostCache> getUdpHostCaches() {
        return this.udpHostCaches;
    }

    public UdpHostCache getUdpHostCache() {
        return this.udpHostCache;
    }

    public byte[] getBody() {
        return this.body;
    }

    @Override
    public ByteBuffer createMessageBuffer() {
        return ByteBuffer.wrap(this.body);
    }

    public byte[] getbytes() {
        byte[] data = new byte[23 + this.body.length];
        byte[] hdr = this.getHeader().getBytes();
        System.arraycopy(hdr, 0, data, 0, 23);
        System.arraycopy(this.body, 0, data, 23, this.body.length);
        return data;
    }

    public String getDebugString() {
        return "Pong[ Addr=" + this.pongAddress + ", FileCount=" + this.fileCount + ", FileSize=" + this.fileSizeInKB + ", AvgUptime=" + this.avgDailyUptime + ", HEX=[" + HexConverter.toHexString(this.body) + "] ]";
    }

    private void buildBody() {
        byte[] ggepExtension;
        int extensionLength = 0;
        if (this.ggepBlock != null) {
            ggepExtension = this.ggepBlock.getBytes();
            extensionLength = ggepExtension.length;
        } else {
            ggepExtension = null;
            extensionLength = 0;
        }
        this.body = new byte[I2P_DEST_LENGTH + NULL_TERM_LENGTH + FILECOUNT_LENGTH + FILESIZE_LENGTH + extensionLength];
        int offset = IOUtil.serializeString(this.pongAddress.getFullHostName(), this.body, 0);
        this.body[offset++] = 0;
        offset = IOUtil.serializeIntLE((int)this.fileCount, this.body, offset);
        offset = IOUtil.serializeIntLE((int)this.fileSizeInKB, this.body, offset);
        if (ggepExtension != null) {
            System.arraycopy(ggepExtension, 0, this.body, offset, extensionLength);
        }
    }

    private void parseBody() {
        StringBuffer buffer = new StringBuffer();
        int offset = IOUtil.deserializeString(this.body, 0, buffer);
        try {
            this.pongAddress = PresentationManager.getInstance().createHostAddress(buffer.toString(), -1);
        }
        catch (MalformedDestAddressException e) {
            e.printStackTrace();
            return;
        }
        this.fileCount = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(this.body, ++offset));
        this.fileSizeInKB = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(this.body, offset + 4));
        if (this.body.length <= offset + 8) {
            return;
        }
        this.parseGGEPBlocks();
    }

    private void parseGGEPBlocks() {
        byte[] data;
        NLogger.warn(PongMsg.class, (Object)"Parsing Pong message GGEP blocks.");
        PhexSecurityManager securityMgr = PhexSecurityManager.getInstance();
        this.ggepBlock = GGEPBlock.mergeGGEPBlocks(GGEPBlock.parseGGEPBlocks(this.body, 14));
        if (this.ggepBlock.isExtensionAvailable("VC") && (data = this.ggepBlock.getExtensionData("VC")).length >= 4) {
            this.vendor = new String(data, 0, 4).intern();
            if (data.length > 4) {
                this.vendorVersionMajor = data[4] >> 4;
                this.vendorVersionMinor = data[4] & 0xF;
            }
        }
        if (this.ggepBlock.isExtensionAvailable("DU")) {
            data = this.ggepBlock.getExtensionData("DU");
            if (data != null && data.length >= 1 && data.length <= 4) {
                try {
                    this.avgDailyUptime = IOUtil.deserializeIntLE(data, 0, data.length);
                }
                catch (IllegalArgumentException exp) {
                    NLogger.warn(PongMsg.class, (Object)("Invalid average uptime GGEP extension data: " + HexConverter.toHexString(data)));
                    this.avgDailyUptime = -1;
                }
            } else {
                NLogger.warn(PongMsg.class, (Object)("Invalid average uptime GGEP extension data: " + HexConverter.toHexString(data)));
                this.avgDailyUptime = -1;
            }
        }
        if (this.ggepBlock.isExtensionAvailable("IPP") && (data = this.ggepBlock.getExtensionData("IPP")) != null) {
            this.ippDestAddresses = PongMsg.unpackIpPortData(data, securityMgr);
        }
    }

    private static Set<DestAddress> unpackIpPortData(byte[] data, PhexSecurityManager securityMgr) {
        HashSet<DestAddress> destAddresses = null;
        NLogger.warn(PongMsg.class, (Object)"Unpacking Pong message IPP message.");
        try {
            int FIELD_SIZE = I2P_DEST_LENGTH;
            if (data.length % FIELD_SIZE != 0) {
                throw new InvalidGGEPBlockException("invalid IPPORT EXTENSION DATA IN PONG");
            }
            int size = data.length / FIELD_SIZE;
            destAddresses = new HashSet<DestAddress>();
            for (int i = 0; i < size; ++i) {
                int index = i * FIELD_SIZE;
                byte[] destBytes = new byte[I2P_DEST_LENGTH];
                System.arraycopy(data, index, destBytes, 0, I2P_DEST_LENGTH);
                String destBase64 = destBytes.toString();
                DestAddress current = null;
                try {
                    current = PresentationManager.getInstance().createHostAddress(destBase64, -1);
                }
                catch (MalformedDestAddressException e) {
                    NLogger.warn(PongMsg.class, (Object)"Malformed destination in Pong message IPP extension.");
                }
                AccessType access = securityMgr.controlHostAddressAccess(current);
                if (access != AccessType.ACCESS_GRANTED) continue;
                destAddresses.add(current);
            }
        }
        catch (InvalidGGEPBlockException exp) {
            NLogger.warn(PongMsg.class, (Object)exp);
        }
        return destAddresses;
    }

    public boolean isUltrapeerMarked() {
        if (this.fileSizeInKB < 8L) {
            return false;
        }
        return (this.fileSizeInKB & this.fileSizeInKB - 1L) == 0L;
    }

    private static int createUltrapeerMarking(int kbytes) {
        if (kbytes < 12) {
            return 8;
        }
        int bitCount = IOUtil.determineBitCount(kbytes);
        int power = (int)Math.pow(2.0, bitCount);
        int minBorder = power - power / 4;
        if (kbytes < minBorder) {
            power = (int)Math.pow(2.0, bitCount - 1);
        }
        return power;
    }
}

