/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import phex.common.log.NLogger;
import phex.host.Host;
import phex.io.buffer.ByteBuffer;
import phex.msg.GGEPBlock;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.utils.HexConverter;
import phex.utils.IOUtil;

public class PingMsg
extends Message {
    private byte[] body;
    private byte[] udpScpByte = null;
    public static final byte UDP_SCP_MASK = 1;
    public static final byte UDP_SCP_LEAF = 0;
    public static final byte UDP_SCP_ULTRAPEER = 1;

    public PingMsg(byte ttl) {
        super(new MsgHeader(0, ttl, 0));
        this.body = IOUtil.EMPTY_BYTE_ARRAY;
    }

    public PingMsg(MsgHeader aHeader, byte[] aBody) {
        super(aHeader);
        this.getHeader().setPayloadType((byte)0);
        this.body = aBody;
        this.getHeader().setDataLength(this.body.length);
    }

    public static PingMsg createUdpPingMsg(boolean isUltrapeer) {
        byte[] udpScpByteArr = new byte[]{isUltrapeer ? (byte)1 : 0};
        GGEPBlock scpExtension = new GGEPBlock(false);
        scpExtension.addExtension("SCP", udpScpByteArr);
        byte[] body = scpExtension.getBytes();
        PingMsg udpPingMsg = new PingMsg(1);
        udpPingMsg.getHeader().setDataLength(body.length);
        udpPingMsg.body = body;
        udpPingMsg.udpScpByte = udpScpByteArr;
        NLogger.debug(PingMsg.class, (Object)("Created UDP Ping " + udpPingMsg.toString()));
        return udpPingMsg;
    }

    public static PingMsg createUdpPingMsg(byte[] bytesMsg, Host fromHost) throws InvalidMessageException {
        MsgHeader msgHdr = MsgHeader.createMsgHeader(bytesMsg, 0);
        return PingMsg.createUdpPingMsg(msgHdr, bytesMsg, 23, fromHost);
    }

    public static PingMsg createUdpPingMsg(MsgHeader msgHdr, byte[] data, int offset, Host fromHost) throws InvalidMessageException {
        msgHdr.setFromHost(fromHost);
        byte[] body = MessageProcessor.createBody(msgHdr, data, offset);
        if (body == null) {
            throw new InvalidMessageException(" Could not create Msg Body while trying to create udp ping message.");
        }
        PingMsg udpPing = new PingMsg(msgHdr, body);
        udpPing.parseGGEPBlocks();
        return udpPing;
    }

    @Override
    public ByteBuffer createMessageBuffer() {
        return ByteBuffer.wrap(this.body);
    }

    public byte[] getBytes() {
        byte[] data = new byte[23 + this.body.length];
        byte[] hdr = this.getHeader().getBytes();
        System.arraycopy(hdr, 0, data, 0, 23);
        System.arraycopy(this.body, 0, data, 23, this.body.length);
        return data;
    }

    private void parseGGEPBlocks() {
        GGEPBlock ggepBlock = GGEPBlock.mergeGGEPBlocks(GGEPBlock.parseGGEPBlocks(this.body, 0));
        if (ggepBlock.isExtensionAvailable("SCP")) {
            this.udpScpByte = ggepBlock.getExtensionData("SCP");
        }
    }

    public byte[] getScpByte() {
        return this.udpScpByte;
    }

    public String toString() {
        return this.getDebugString();
    }

    public String getDebugString() {
        return "Ping[ HEX=[" + HexConverter.toHexString(this.body) + "] ]";
    }
}

