/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import java.io.InputStream;
import phex.common.log.NLogger;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.PingMsg;
import phex.msg.PongMsg;
import phex.msg.PushRequestMsg;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.RouteTableUpdateMsg;
import phex.msg.vendor.VendorMsg;
import phex.net.connection.Connection;
import phex.utils.IOUtil;

public class MessageProcessor {
    private MessageProcessor() {
    }

    public static Message parseMessage(Connection connection) throws IOException, InvalidMessageException {
        MsgHeader header = MessageProcessor.parseMessageHeader(connection, new byte[23]);
        if (header == null) {
            throw new IOException("Connection closed by remote host");
        }
        return MessageProcessor.parseMessage(header, connection);
    }

    public static Message parseMessage(MsgHeader header, Connection connection) throws IOException, InvalidMessageException {
        return MessageProcessor.parseMessage(header, connection.getInputStream());
    }

    public static Message parseMessage(MsgHeader header, InputStream inStream) throws IOException, InvalidMessageException {
        byte[] body = MessageProcessor.readMessageBody(inStream, header.getDataLength());
        Message message = MessageProcessor.createMessageFromBody(header, body);
        return message;
    }

    public static Message createMessageFromBody(MsgHeader header, byte[] body) throws InvalidMessageException {
        switch (header.getPayload()) {
            case 0: {
                return new PingMsg(header, body);
            }
            case 1: {
                return new PongMsg(header, body);
            }
            case 64: {
                return new PushRequestMsg(header, body);
            }
            case -127: {
                return new QueryResponseMsg(header, body);
            }
            case -128: {
                return new QueryMsg(header, body);
            }
            case 48: {
                return RouteTableUpdateMsg.parseMessage(header, body);
            }
            case 49: 
            case 50: {
                return VendorMsg.parseMessage(header, body);
            }
        }
        return null;
    }

    public static byte[] readMessageBody(Connection connection, int dataLength) throws IOException {
        return MessageProcessor.readMessageBody(connection.getInputStream(), dataLength);
    }

    public static byte[] readMessageBody(InputStream inStream, int dataLength) throws IOException {
        int len;
        byte[] body = new byte[dataLength];
        for (int dataRead = 0; dataRead < dataLength; dataRead += len) {
            int readSize = Math.min(dataLength - dataRead, 1024);
            len = inStream.read(body, dataRead, readSize);
            if (len != -1) continue;
            throw new IOException("Connection closed by remote host");
        }
        return body;
    }

    public static MsgHeader parseMessageHeader(Connection connection, byte[] buffer) throws IOException {
        return MessageProcessor.parseMessageHeader(connection.getInputStream(), buffer);
    }

    public static MsgHeader parseMessageHeader(InputStream inStream, byte[] buffer) throws IOException {
        int len;
        for (int lenRead = 0; lenRead < 23; lenRead += len) {
            len = inStream.read(buffer, lenRead, 23 - lenRead);
            if (len != -1) continue;
            return null;
        }
        byte[] guidArr = new byte[16];
        System.arraycopy(buffer, 0, guidArr, 0, 16);
        byte payload = buffer[16];
        byte ttl = buffer[17];
        byte hops = buffer[18];
        int dataLength = IOUtil.deserializeIntLE(buffer, 19);
        MsgHeader header = new MsgHeader(new GUID(guidArr), payload, ttl, hops, dataLength);
        return header;
    }

    public static byte[] createBody(MsgHeader MsgHdr, byte[] data, int offset) {
        int bodyLength = MsgHdr.getDataLength();
        byte[] body = new byte[bodyLength];
        if (bodyLength > data.length - offset) {
            NLogger.warn(MessageProcessor.class, (Object)(" Message Data length greater then that of given byte array " + new String(data)));
            return null;
        }
        System.arraycopy(data, offset, body, 0, bodyLength);
        return body;
    }
}

