/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import phex.utils.HexConverter;
import phex.utils.IOUtil;

public class GUID
implements Serializable {
    public static final int DATA_LENGTH = 16;
    public static final GUID EMPTY_GUID;
    public static final Random randomizer;
    private byte[] bytes;
    private String stringRepresentation = null;

    public GUID() {
        this.bytes = new byte[16];
        randomizer.nextBytes(this.bytes);
        this.bytes[8] = -1;
        this.bytes[15] = 0;
    }

    public GUID(String hexValue) {
        this.fromHexString(hexValue);
    }

    public GUID(byte[] guidBytes) {
        if (guidBytes.length != 16) {
            throw new IllegalArgumentException("Attempted to construct a GUID from an array of bytes not 16 long: " + guidBytes.length);
        }
        this.bytes = guidBytes;
        this.stringRepresentation = null;
    }

    public void setGuid(byte[] guidBytes) {
        System.arraycopy(guidBytes, 0, this.bytes, 0, 16);
        this.stringRepresentation = null;
    }

    public byte[] getGuid() {
        return this.bytes;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GUID) {
            return Arrays.equals(this.bytes, ((GUID)obj).bytes);
        }
        return false;
    }

    public void copy(byte[] guidBytes) {
        System.arraycopy(guidBytes, 0, this.bytes, 0, 16);
        this.stringRepresentation = null;
    }

    public int serialize(byte[] outbuf, int offset) {
        System.arraycopy(this.bytes, 0, outbuf, offset, 16);
        return offset + 16;
    }

    public void write(OutputStream stream) throws IOException {
        stream.write(this.bytes);
    }

    public int deserialize(byte[] inbuf, int offset) {
        System.arraycopy(inbuf, offset, this.bytes, 0, 16);
        this.stringRepresentation = null;
        return offset + 16;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = this.generateString();
        }
        return this.stringRepresentation;
    }

    private String generateString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append(HexConverter.toHexString(this.bytes, 0, 4));
        buffer.append('-');
        buffer.append(HexConverter.toHexString(this.bytes, 4, 2));
        buffer.append('-');
        buffer.append(HexConverter.toHexString(this.bytes, 6, 2));
        buffer.append('-');
        buffer.append(HexConverter.toHexString(this.bytes, 8, 2));
        buffer.append('-');
        buffer.append(HexConverter.toHexString(this.bytes, 10, 6));
        return buffer.toString();
    }

    public String toHexString() {
        return HexConverter.toHexString(this.bytes);
    }

    public void fromHexString(String hexValue) {
        this.bytes = HexConverter.toBytes(hexValue);
        this.stringRepresentation = null;
    }

    public int hashCode() {
        int v1 = 0xFF & this.bytes[0] | 0xFF00 & this.bytes[1] << 8 | 0xFF0000 & this.bytes[2] << 16 | this.bytes[3] << 24;
        int v2 = 0xFF & this.bytes[4] | 0xFF00 & this.bytes[5] << 8 | 0xFF0000 & this.bytes[6] << 16 | this.bytes[7] << 24;
        int v3 = 0xFF & this.bytes[8] | 0xFF00 & this.bytes[9] << 8 | 0xFF0000 & this.bytes[10] << 16 | this.bytes[11] << 24;
        int v4 = 0xFF & this.bytes[12] | 0xFF00 & this.bytes[13] << 8 | 0xFF0000 & this.bytes[14] << 16 | this.bytes[15] << 24;
        return v1 ^ v2 ^ v3 ^ v4;
    }

    static {
        int ipValue;
        EMPTY_GUID = new GUID(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        long time = System.currentTimeMillis();
        try {
            ipValue = IOUtil.deserializeIntLE(InetAddress.getLocalHost().getAddress(), 0);
        }
        catch (Exception e) {
            ipValue = 0;
        }
        int shift = IOUtil.determineBitCount(ipValue);
        long seed = time << shift;
        randomizer = new Random(seed += (long)ipValue);
    }

    public static class GUIDComparator
    implements Comparator<GUID> {
        @Override
        public int compare(GUID g1, GUID g2) {
            for (int i = 0; i < 16; ++i) {
                int diff = g1.bytes[i] - g2.bytes[i];
                if (diff == 0) continue;
                return diff;
            }
            return 0;
        }
    }
}

