/*
 * Decompiled with CFR 0.152.
 */
package phex.io.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import phex.common.bandwidth.BandwidthController;

public class BandwidthByteChannel
implements ByteChannel {
    private ByteChannel delegate;
    private BandwidthController bandwidthController;

    public BandwidthByteChannel(ByteChannel delegate, BandwidthController bandwidthController) {
        if (delegate == null) {
            throw new NullPointerException("no delegate");
        }
        this.delegate = delegate;
        this.bandwidthController = bandwidthController;
    }

    public void setBandwidthController(BandwidthController bandwidthController) {
        this.bandwidthController = bandwidthController;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int pos = dst.position();
        int len = dst.limit() - pos;
        int available = this.bandwidthController.getAvailableByteCount(len, true, false);
        dst.limit(pos + available);
        int readLen = this.delegate.read(dst);
        if (readLen >= 0) {
            this.bandwidthController.markBytesUsed(readLen);
        }
        return readLen;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int pos = src.position();
        int len = src.limit() - pos;
        int totalWritten = 0;
        while (len > 0) {
            int available = this.bandwidthController.getAvailableByteCount(len, true, true);
            src.limit(pos + available);
            int written = this.delegate.write(src);
            len -= written;
            totalWritten += written;
            pos = src.position();
        }
        return totalWritten;
    }
}

