/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.util.TimerTask;
import phex.common.Environment;
import phex.common.LongObj;
import phex.common.log.NLogger;
import phex.prefs.core.BandwidthPrefs;
import phex.prefs.core.ConnectionPrefs;
import phex.servent.Servent;
import phex.servent.ServentInfo;
import phex.statistic.StatisticsManager;
import phex.statistic.UptimeStatisticProvider;

public class UltrapeerCapabilityChecker
extends TimerTask {
    private static final long TIMER_PERIOD = 10000L;
    private static final long TWENTY_MINUTES = 1200000L;
    private static final long TEN_MINUTES = 600000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long TWO_HOURS = 0x6DDD00L;
    private final ServentInfo serventInfo;
    private boolean isUltrapeerCapable;
    private boolean isUltrapeerOS;
    private UptimeStatisticProvider uptimeProvider;

    public UltrapeerCapabilityChecker(Servent servent) {
        this.serventInfo = servent;
        Environment env = Environment.getInstance();
        this.isUltrapeerOS = env.isUltrapeerOS();
        this.uptimeProvider = (UptimeStatisticProvider)StatisticsManager.getInstance().getStatisticProvider("UptimeProvider");
        env.scheduleTimerTask(this, 0L, 10000L);
    }

    @Override
    public void run() {
        try {
            this.checkIfUltrapeerCapable();
        }
        catch (Throwable th) {
            NLogger.error(UltrapeerCapabilityChecker.class, (Object)th, th);
        }
    }

    private void checkIfUltrapeerCapable() {
        boolean isCapable;
        this.isUltrapeerCapable = isCapable = ConnectionPrefs.AllowToBecomeUP.get() != false && !this.serventInfo.isFirewalled() && this.isUltrapeerOS && BandwidthPrefs.NetworkSpeedKbps.get() > 64 && BandwidthPrefs.MaxNetworkBandwidth.get() > 10240 && BandwidthPrefs.MaxTotalBandwidth.get() > 14336 && (((LongObj)this.uptimeProvider.getValue()).getValue() > 1200000L || ((LongObj)this.uptimeProvider.getAverageValue()).getValue() > 600000L);
    }

    public boolean isUltrapeerCapable() {
        return this.isUltrapeerCapable;
    }
}

