/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import phex.common.QueryRoutingTable;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.connection.ConnectionClosedException;
import phex.connection.MessageQueue;
import phex.host.HostStatus;
import phex.io.buffer.ByteBuffer;
import phex.msg.Message;
import phex.msg.QueryMsg;
import phex.msg.vendor.CapabilitiesVMsg;
import phex.msg.vendor.MessagesSupportedVMsg;
import phex.net.connection.Connection;
import phex.prefs.core.SecurityPrefs;
import phex.servent.Servent;
import phex.statistic.MessageCountStatistic;
import phex.utils.GnutellaInputStream;
import phex.utils.GnutellaOutputStream;

public class Host {
    private static final int MAX_SEND_QUEUE = 400;
    private static final int DROP_PACKAGE_RATIO = 70;
    private static final Long ZERO_LONG = new Long(0L);
    private long QUERY_ROUTING_UPDATE_TIME = 300000L;
    private static final int STABLE_CONNECTION_TIME = 60000;
    public static final byte CONNECTION_NORMAL = 0;
    public static final byte CONNECTION_LEAF_UP = 1;
    public static final byte CONNECTION_UP_UP = 2;
    public static final byte CONNECTION_UP_LEAF = 3;
    private DestAddress hostAddress;
    private Connection connection = null;
    private HostStatus status = HostStatus.NOT_CONNECTED;
    private String lastStatusMsg = "";
    private long statusTime = 0L;
    private Type type = Type.OUTGOING;
    private int receivedMsgCount = 0;
    private int sentMsgCount = 0;
    private int droppedMsgCount = 0;
    private long fileCount = -1L;
    private long shareSize = -1L;
    private String vendor;
    private boolean vendorChecked = false;
    private byte maxTTL = (byte)4;
    private byte hopsFlowLimit = (byte)-1;
    private int ultrapeerDegree;
    private boolean isConnectionStable = false;
    private boolean isQueryRoutingSupported = false;
    private boolean isUPQueryRoutingSupported = false;
    private boolean isDynamicQuerySupported = false;
    private long lastQRTableSentTime;
    private QueryRoutingTable lastSentQRTable;
    private QueryRoutingTable lastReceivedQRTable;
    private byte connectionType = 0;
    private MessageQueue messageQueue;
    private SendEngine sendEngine;
    private boolean isVendorMessageSupported = false;
    private MessagesSupportedVMsg supportedVMsgs;
    private CapabilitiesVMsg capabilitiesVMsgs;
    private DestAddress pushProxyAddress;
    public static final LocalHost LOCAL_HOST = new LocalHost();

    public Host() {
    }

    public Host(DestAddress address) {
        this();
        this.hostAddress = address;
    }

    public Host(DestAddress address, Connection connection) {
        this();
        this.hostAddress = address;
        this.connection = connection;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.receivedMsgCount = 0;
        this.sentMsgCount = 0;
        this.droppedMsgCount = 0;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Deprecated
    public GnutellaInputStream getInputStream() throws IOException {
        if (this.connection == null) {
            throw new ConnectionClosedException("Connection already closed");
        }
        return this.connection.getInputStream();
    }

    @Deprecated
    public GnutellaOutputStream getOutputStream() throws IOException {
        if (this.connection == null) {
            throw new ConnectionClosedException("Connection already closed");
        }
        return this.connection.getOutputStream();
    }

    public void activateInputInflation() throws IOException {
        this.getInputStream().activateInputInflation();
    }

    public void activateOutputDeflation() throws IOException {
        this.getOutputStream().activateOutputDeflation();
    }

    public void setVendor(String aVendor) {
        this.vendor = aVendor;
    }

    public String getVendor() {
        return this.vendor;
    }

    public HostStatus getStatus() {
        return this.status;
    }

    public String getLastStatusMsg() {
        return this.lastStatusMsg;
    }

    public void setStatus(HostStatus status) {
        this.setStatus(status, null, System.currentTimeMillis());
    }

    public void setStatus(HostStatus status, long statusTime) {
        this.setStatus(status, null, statusTime);
    }

    public void setStatus(HostStatus status, String msg) {
        this.setStatus(status, msg, System.currentTimeMillis());
    }

    public void setStatus(HostStatus status, String msg, long statusTime) {
        if (this.status == status && this.lastStatusMsg != null && this.lastStatusMsg.equals(msg)) {
            return;
        }
        this.status = status;
        this.lastStatusMsg = msg;
        this.statusTime = statusTime;
    }

    public void checkForStableConnection(long currentTime) {
        if (this.isConnectionStable) {
            return;
        }
        if (this.status == HostStatus.CONNECTED && this.getConnectionUpTime(currentTime) > 60000L) {
            this.isConnectionStable = true;
        }
    }

    public boolean isConnectionStable() {
        return this.isConnectionStable;
    }

    public long getConnectionUpTime(long currentTime) {
        if (this.status == HostStatus.CONNECTED) {
            return currentTime - this.statusTime;
        }
        return 0L;
    }

    public Long getConnectionUpTimeObject(long currentTime) {
        if (this.status == HostStatus.CONNECTED) {
            return new Long(currentTime - this.statusTime);
        }
        return ZERO_LONG;
    }

    public boolean isErrorStatusExpired(long currentTime, long expiryDelay) {
        return (this.status == HostStatus.ERROR || this.status == HostStatus.DISCONNECTED) && currentTime - this.statusTime > expiryDelay;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type aType) {
        this.type = aType;
    }

    public boolean isIncomming() {
        return this.type.equals((Object)Type.INCOMING);
    }

    public void setVendorMessageSupported(boolean state) {
        this.isVendorMessageSupported = state;
    }

    public boolean isVendorMessageSupported() {
        return this.isVendorMessageSupported;
    }

    public void setCapabilitiesVMsgs(CapabilitiesVMsg capabilitiesVMsgs) {
        this.capabilitiesVMsgs = capabilitiesVMsgs;
    }

    public boolean isFeatureSearchSupported() {
        return this.capabilitiesVMsgs != null && this.capabilitiesVMsgs.isFeatureSearchSupported();
    }

    public void setSupportedVMsgs(MessagesSupportedVMsg supportedVMsgs) {
        this.supportedVMsgs = supportedVMsgs;
    }

    public boolean isTCPConnectBackSupported() {
        return false;
    }

    public boolean isTCPConnectBackRedirectSupported() {
        return false;
    }

    public boolean isPushProxySupported() {
        return false;
    }

    public boolean isHopsFlowSupported() {
        return false;
    }

    public DestAddress getPushProxyAddress() {
        return this.pushProxyAddress;
    }

    public void setPushProxyAddress(DestAddress address) {
        this.pushProxyAddress = address;
    }

    public void incReceivedCount() {
        ++this.receivedMsgCount;
    }

    public int getReceivedCount() {
        return this.receivedMsgCount;
    }

    public void incSentCount() {
        ++this.sentMsgCount;
    }

    public int getSentCount() {
        return this.sentMsgCount;
    }

    public void incDropCount() {
        ++this.droppedMsgCount;
    }

    public int getDropCount() {
        return this.droppedMsgCount;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(long fileCount) {
        this.fileCount = fileCount;
    }

    public long getTotalSize() {
        return this.shareSize;
    }

    public void setTotalFileSize(long shareSize) {
        this.shareSize = shareSize;
    }

    public byte getMaxTTL() {
        return this.maxTTL;
    }

    public void setMaxTTL(byte maxTTL) {
        this.maxTTL = maxTTL;
    }

    public byte getHopsFlowLimit() {
        return this.hopsFlowLimit;
    }

    public void setHopsFlowLimit(byte hopsFlowLimit) {
        this.hopsFlowLimit = hopsFlowLimit;
    }

    public int getUltrapeerDegree() {
        return this.ultrapeerDegree;
    }

    public void setUltrapeerDegree(int degree) {
        this.ultrapeerDegree = degree;
    }

    public boolean tooManyDropPackets() {
        if (this.receivedMsgCount < 50 && this.getConnectionUpTime(System.currentTimeMillis()) < 60000L) {
            return false;
        }
        return this.droppedMsgCount * 100 / (this.receivedMsgCount + 1) > 70;
    }

    public boolean dropPacketsInRed() {
        return this.droppedMsgCount * 100 / (this.receivedMsgCount + 1) > 52;
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.connection != null) {
            if (this.status != HostStatus.ERROR) {
                this.setStatus(HostStatus.DISCONNECTED);
            }
            this.connection.disconnect();
            this.connection = null;
        }
        if (this.messageQueue != null) {
            MessageQueue messageQueue = this.messageQueue;
            synchronized (messageQueue) {
                this.messageQueue.notify();
            }
        }
        Servent.getInstance().getHostService().getNetworkHostsContainer().disconnectHost(this);
    }

    public int getSendQueueLength() {
        if (this.messageQueue == null) {
            return 0;
        }
        return this.messageQueue.getQueuedMessageCount();
    }

    public int getSendDropCount() {
        if (this.messageQueue == null) {
            return 0;
        }
        return this.messageQueue.getDropCount();
    }

    public boolean isSendQueueTooLong() {
        if (this.messageQueue == null) {
            return false;
        }
        return this.messageQueue.getQueuedMessageCount() >= 399;
    }

    public boolean isSendQueueInRed() {
        if (this.messageQueue == null) {
            return false;
        }
        return this.messageQueue.getQueuedMessageCount() >= 300;
    }

    public boolean isNoVendorDisconnectApplying() {
        if (!SecurityPrefs.DisconnectNoVendorHosts.get().booleanValue()) {
            return false;
        }
        if (this.vendorChecked) {
            return false;
        }
        if (this.status != HostStatus.CONNECTED) {
            return false;
        }
        String normalizedVendorString = this.vendor;
        normalizedVendorString = normalizedVendorString == null ? "" : normalizedVendorString.trim();
        if (normalizedVendorString.length() == 0) {
            return true;
        }
        this.vendorChecked = true;
        return false;
    }

    public boolean isFreeloader(long currentTime) {
        return false;
    }

    public boolean isLeafUltrapeerConnection() {
        return this.connectionType == 1;
    }

    public boolean isUltrapeer() {
        return this.connectionType == 1 || this.connectionType == 2;
    }

    public boolean isUltrapeerLeafConnection() {
        return this.connectionType == 3;
    }

    public void setConnectionType(byte connectionType) {
        this.connectionType = connectionType;
    }

    public String toString() {
        return "Host[" + this.hostAddress.getHostName() + ":" + this.hostAddress.getPort() + "," + this.vendor + ",State=" + (Object)((Object)this.status) + "]";
    }

    public void sendMessage(Message message) throws IOException {
        if (NLogger.isDebugEnabled(Host.class)) {
            NLogger.debug(Host.class, (Object)("Sending message: " + message + " - " + message.getHeader().toString()));
        }
        ByteBuffer headerBuf = message.createHeaderBuffer();
        ByteBuffer messageBuf = message.createMessageBuffer();
        if (!this.isConnected()) {
            throw new ConnectionClosedException("Connection is already closed");
        }
        this.connection.write(headerBuf);
        if (!this.isConnected()) {
            throw new ConnectionClosedException("Connection is already closed");
        }
        this.connection.write(messageBuf);
        if (NLogger.isDebugEnabled(Host.class)) {
            NLogger.debug(Host.class, (Object)("Message send: " + message + " - " + message.getHeader().toString()));
        }
        switch (message.getHeader().getPayload()) {
            case 0: {
                MessageCountStatistic.pingMsgOutCounter.increment(1);
                break;
            }
            case 1: {
                MessageCountStatistic.pongMsgOutCounter.increment(1);
                break;
            }
            case 64: {
                MessageCountStatistic.pushMsgOutCounter.increment(1);
                break;
            }
            case -128: {
                MessageCountStatistic.queryMsgOutCounter.increment(1);
                break;
            }
            case -127: {
                MessageCountStatistic.queryHitMsgOutCounter.increment(1);
                break;
            }
            default: {
                MessageCountStatistic.totalOutMsgCounter.increment(1);
            }
        }
    }

    public void flushOutputStream() throws IOException {
        if (this.isConnected()) {
            this.connection.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMessageToSend(Message message) {
        if (this.hopsFlowLimit > -1 && message instanceof QueryMsg && message.getHeader().getHopsTaken() >= this.hopsFlowLimit) {
            return;
        }
        NLogger.debug(Host.class, (Object)("Queuing message: " + message));
        this.initMessageQueue();
        this.incSentCount();
        MessageQueue messageQueue = this.messageQueue;
        synchronized (messageQueue) {
            this.messageQueue.addMessage(message);
            this.sendEngine.dispatch();
        }
    }

    private void initMessageQueue() {
        if (this.messageQueue != null) {
            return;
        }
        this.messageQueue = new MessageQueue(this);
        this.sendEngine = new SendEngine();
    }

    public boolean isQRTableUpdateRequired() {
        return System.currentTimeMillis() > this.lastQRTableSentTime + this.QUERY_ROUTING_UPDATE_TIME;
    }

    public QueryRoutingTable getLastSentRoutingTable() {
        return this.lastSentQRTable;
    }

    public void setLastSentRoutingTable(QueryRoutingTable routingTable) {
        this.lastSentQRTable = routingTable;
        this.lastQRTableSentTime = System.currentTimeMillis();
    }

    public QueryRoutingTable getLastReceivedRoutingTable() {
        return this.lastReceivedQRTable;
    }

    public void setLastReceivedRoutingTable(QueryRoutingTable routingTable) {
        this.lastReceivedQRTable = routingTable;
    }

    public boolean isQueryRoutingSupported() {
        return this.isQueryRoutingSupported;
    }

    public void setQueryRoutingSupported(boolean state) {
        this.isQueryRoutingSupported = state;
    }

    public boolean isUPQueryRoutingSupported() {
        return this.isUPQueryRoutingSupported;
    }

    public void setUPQueryRoutingSupported(boolean state) {
        this.isUPQueryRoutingSupported = state;
    }

    public boolean isDynamicQuerySupported() {
        return this.isDynamicQuerySupported;
    }

    public void setDynamicQuerySupported(boolean state) {
        this.isDynamicQuerySupported = state;
    }

    public static class LocalHost
    extends Host {
        LocalHost() {
            super(Servent.getInstance().getLocalAddress());
        }

        @Override
        public boolean isConnected() {
            return true;
        }

        @Override
        public Type getType() {
            return Type.LOCAL;
        }
    }

    private class SendEngine
    implements Runnable {
        private AtomicBoolean isRunning = new AtomicBoolean(false);

        private SendEngine() {
        }

        public void dispatch() {
            boolean result = this.isRunning.compareAndSet(false, true);
            if (result) {
                String jobName = "SendEngine-" + Integer.toHexString(Host.this.sendEngine.hashCode());
                ThreadPool.getInstance().addJob(Host.this.sendEngine, jobName);
            }
        }

        @Override
        public void run() {
            do {
                try {
                    Host.this.messageQueue.sendQueuedMessages();
                }
                catch (IOException exp) {
                    Host.this.setStatus(HostStatus.ERROR, exp.getMessage());
                    Host.this.disconnect();
                }
            } while (this.checkForRepeat());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkForRepeat() {
            MessageQueue messageQueue = Host.this.messageQueue;
            synchronized (messageQueue) {
                if (Host.this.isConnected() && Host.this.messageQueue.getQueuedMessageCount() > 0) {
                    return true;
                }
                boolean result = this.isRunning.compareAndSet(true, false);
                if (!result) {
                    throw new RuntimeException("Invalid state.");
                }
                return false;
            }
        }
    }

    public static enum Type {
        OUTGOING,
        INCOMING,
        LOCAL;

    }
}

