/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import phex.common.address.DestAddress;
import phex.host.CaughtHost;
import phex.host.CaughtHostComparator;
import phex.prefs.core.NetworkPrefs;

public class CatchedHostCache {
    private TreeSet<CaughtHost> sortedHosts = new TreeSet<CaughtHost>(new CaughtHostComparator());
    private Map<DestAddress, CaughtHost> addressHostMapping = new HashMap<DestAddress, CaughtHost>();

    public synchronized CaughtHost getCaughHost(DestAddress address) {
        return this.addressHostMapping.get(address);
    }

    public synchronized void add(CaughtHost host) {
        if (this.addressHostMapping.containsKey(host.getHostAddress())) {
            return;
        }
        if (this.sortedHosts.size() < NetworkPrefs.MaxHostInHostCache.get()) {
            this.addressHostMapping.put(host.getHostAddress(), host);
            this.sortedHosts.add(host);
        } else {
            this.addressHostMapping.put(host.getHostAddress(), host);
            this.sortedHosts.add(host);
            if (this.sortedHosts.size() >= NetworkPrefs.MaxHostInHostCache.get()) {
                CaughtHost dropObject = this.sortedHosts.first();
                this.remove(dropObject);
            }
        }
        assert (this.addressHostMapping.size() == this.sortedHosts.size()) : "CatchedHostCache out of sync.";
    }

    public synchronized void remove(CaughtHost host) {
        CaughtHost value = this.addressHostMapping.remove(host.getHostAddress());
        if (value != null) {
            this.sortedHosts.remove(value);
        }
        assert (this.addressHostMapping.size() == this.sortedHosts.size()) : "CatchedHostCache out of sync.";
    }

    public synchronized void clear() {
        this.sortedHosts.clear();
        this.addressHostMapping.clear();
    }

    public synchronized Iterator<CaughtHost> iterator() {
        return this.sortedHosts.iterator();
    }
}

