/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.monitor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.gui.actions.BanHostActionUtils;
import phex.gui.actions.FWAction;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumn;
import phex.gui.common.table.SortedTableHeaderRenderer;
import phex.gui.common.treetable.JTreeTable;
import phex.gui.dialogs.DownloadConfigDialog;
import phex.gui.models.ISearchDataModel;
import phex.gui.models.SearchTreeTableModel;
import phex.gui.renderer.SearchResultsRowRenderer;
import phex.gui.renderer.SearchTreeCellRenderer;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.search.SearchResultElement;
import phex.gui.tabs.search.monitor.ResultMonitorDataModel;
import phex.msg.QueryResponseMsg;
import phex.query.FilteredQueryResponseMonitor;
import phex.query.SearchFilter;
import phex.servent.Servent;
import phex.share.SharedFilesService;
import phex.utils.Localizer;
import phex.utils.StringUtils;
import phex.utils.URLUtil;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;

public class ResultMonitorTab
extends FWTab {
    private static final RemoteFile[] EMPTY_REMOTE_FILE_ARRAY = new RemoteFile[0];
    private static final String PASSIVE_SEARCH_TABLE_IDENTIFIER = "PassiveSearchTable";
    private JPopupMenu searchResultPopup;
    private JTextField mPassiveSearch;
    private JButton mPassiveButton;
    private JTreeTable searchTreeTable;
    private SearchTreeTableModel searchTreeTableModel;
    private ResultMonitorDataModel resultDataModel;
    private JScrollPane searchTreeTableScrollPane;
    private static final String QUICK_DOWNLOAD_ACTION_KEY = "SWQuickDownloadAction";
    private static final String CONFIG_DOWNLOAD_ACTION_KEY = "SWConfigDownloadAction";
    private static final String VIEW_BITZI_TICKET_ACTION_KEY = "ViewBitziTicketAction";
    private static final String CHAT_TO_HOST_ACTION_KEY = "ChatToHostAction";
    private static final String BROWSE_HOST_ACTION_KEY = "BrowseHostAction";
    private static final String ADD_TO_FAVORITES_ACTION_KEY = "AddToFavoritesAction";

    public ResultMonitorTab() {
        super(1009, Localizer.getString("ResultMonitorTab_ResultMonitor"), GUIRegistry.getInstance().getPlafIconPack().getIcon("ResultMonitor.Tab"), Localizer.getString("ResultMonitorTab_TTTResultMonitor"), Localizer.getChar("ResultMonitorTab_Mnemonic"), KeyStroke.getKeyStroke(Localizer.getString("ResultMonitorTab_Accelerator")), 8);
    }

    public void initComponent(DGuiSettings guiSettings) {
        CellConstraints cc = new CellConstraints();
        FormLayout tabLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:p:grow, 2dlu");
        PanelBuilder tabBuilder = new PanelBuilder(tabLayout, this);
        JPanel contentPanel = new JPanel();
        FWElegantPanel banner = new FWElegantPanel(Localizer.getString("ResultMonitorTab_ResultMonitor"), contentPanel);
        tabBuilder.add((Component)banner, cc.xy(2, 2));
        FormLayout contentLayout = new FormLayout("fill:d:grow", "p, 1dlu, fill:d:grow, 1dlu, p");
        PanelBuilder contentBuilder = new PanelBuilder(contentLayout, contentPanel);
        JPanel headerPanel = new JPanel();
        contentBuilder.add((Component)headerPanel, cc.xy(1, 1));
        FormLayout headerLayout = new FormLayout("d, 1dlu, d, 1dlu, d, 1dlu, d", "p");
        PanelBuilder headerBuilder = new PanelBuilder(headerLayout, headerPanel);
        headerBuilder.addLabel(Localizer.getString("ResultMonitorTab_ResultFilter"), cc.xy(1, 1));
        this.mPassiveSearch = new JTextField("", 20);
        this.mPassiveSearch.setToolTipText(Localizer.getString("ResultMonitorTab_TTTPassiveSearch"));
        headerBuilder.add((Component)this.mPassiveSearch, cc.xy(3, 1));
        this.mPassiveButton = new JButton(Localizer.getString("ResultMonitorTab_StartPassiveSearch"));
        this.mPassiveButton.setToolTipText(Localizer.getString("ResultMonitorTab_TTTStartPassiveSearch"));
        this.mPassiveButton.addActionListener(new PassiveSearchHandler());
        headerBuilder.add((Component)this.mPassiveButton, cc.xy(5, 1));
        MouseHandler mouseHandler = new MouseHandler();
        this.searchTreeTableModel = new SearchTreeTableModel();
        this.searchTreeTable = new JTreeTable(this.searchTreeTableModel);
        GUIUtils.updateTableFromDGuiSettings(guiSettings, this.searchTreeTable, PASSIVE_SEARCH_TABLE_IDENTIFIER);
        this.searchTreeTable.activateHeaderPopupMenu();
        this.searchTreeTable.activateColumnResizeToFit();
        JTableHeader header = this.searchTreeTable.getTableHeader();
        header.setDefaultRenderer(new SortedTableHeaderRenderer(this.searchTreeTable));
        header.addMouseListener(new TableHeaderMouseHandler());
        this.searchTreeTable.addMouseListener(mouseHandler);
        this.searchTreeTable.setAutoResizeMode(0);
        this.searchTreeTable.getSelectionModel().addListSelectionListener(new SearchTreeTableSelectionListener());
        this.searchTreeTable.setTreeCellRenderer(new SearchTreeCellRenderer());
        SharedFilesService sharedFilesService = Servent.getInstance().getSharedFilesService();
        SwarmingManager swarmingMgr = SwarmingManager.getInstance();
        SearchResultsRowRenderer resultRowRenderer = new SearchResultsRowRenderer(sharedFilesService, swarmingMgr);
        List<TableColumn> colList = this.searchTreeTable.getColumns(true);
        for (TableColumn column : colList) {
            column.setCellRenderer(resultRowRenderer);
        }
        this.searchTreeTableScrollPane = FWTable.createFWTableScrollPane(this.searchTreeTable);
        this.searchTreeTableScrollPane.addMouseListener(mouseHandler);
        contentBuilder.add((Component)this.searchTreeTableScrollPane, cc.xy(1, 3));
        this.resultDataModel = new ResultMonitorDataModel();
        this.searchTreeTableModel.setDisplayedSearch(this.resultDataModel);
        FWToolBar resultToolbar = new FWToolBar(0);
        resultToolbar.setBorderPainted(false);
        resultToolbar.setFloatable(false);
        contentBuilder.add((Component)resultToolbar, cc.xy(1, 5));
        this.searchResultPopup = new JPopupMenu();
        FWAction action = new SWQuickDownloadAction();
        this.addTabAction(QUICK_DOWNLOAD_ACTION_KEY, action);
        resultToolbar.addAction(action);
        this.searchResultPopup.add(action);
        action = new SWConfigDownloadAction();
        this.addTabAction(CONFIG_DOWNLOAD_ACTION_KEY, action);
        resultToolbar.addAction(action);
        this.searchResultPopup.add(action);
        action = new ViewBitziTicketAction();
        this.addTabAction(VIEW_BITZI_TICKET_ACTION_KEY, action);
        resultToolbar.addAction(action);
        this.searchResultPopup.add(action);
        this.searchResultPopup.addSeparator();
        action = new AddToFavoritesAction();
        this.addTabAction(ADD_TO_FAVORITES_ACTION_KEY, action);
        this.searchResultPopup.add(action);
        action = new BrowseHostAction();
        this.addTabAction(BROWSE_HOST_ACTION_KEY, action);
        resultToolbar.addAction(action);
        this.searchResultPopup.add(action);
        action = new ChatToHostAction();
        this.addTabAction(CHAT_TO_HOST_ACTION_KEY, action);
        resultToolbar.addAction(action);
        this.searchResultPopup.add(action);
        BanHostActionProvider banHostActionProvider = new BanHostActionProvider();
        BanHostActionUtils.BanHostActionMenu bhActionMenu = BanHostActionUtils.createActionMenu(banHostActionProvider);
        this.searchResultPopup.add(bhActionMenu.menu);
        this.addTabActions(bhActionMenu.actions);
        action = BanHostActionUtils.createToolBarAction(banHostActionProvider);
        resultToolbar.addAction(action);
        this.addTabAction(action);
        this.searchResultPopup.addSeparator();
    }

    @Override
    public boolean isVisibleByDefault() {
        return false;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.searchTreeTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.searchTreeTableScrollPane);
        }
    }

    private RemoteFile getSelectedRemoteFile(boolean useRepresent) {
        RemoteFile remoteFile;
        ISearchDataModel searchDataModel = this.searchTreeTableModel.getDisplayedResultsData();
        if (searchDataModel == null) {
            return null;
        }
        TreePath selectionPath = this.searchTreeTable.getTreeSelectionModel().getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        if (selectionPath.getPathCount() == 3) {
            remoteFile = (RemoteFile)selectionPath.getPathComponent(2);
        } else {
            SearchResultElement element = (SearchResultElement)selectionPath.getPathComponent(1);
            if (!useRepresent && element.getRemoteFileListCount() != 0) {
                return null;
            }
            remoteFile = element.getSingleRemoteFile();
        }
        return remoteFile;
    }

    public RemoteFile[] getSelectedRemoteFiles(boolean singleForAll) {
        ISearchDataModel searchDataModel = this.searchTreeTableModel.getDisplayedResultsData();
        if (searchDataModel == null) {
            return EMPTY_REMOTE_FILE_ARRAY;
        }
        TreePath[] selectionPaths = this.searchTreeTable.getTreeSelectionModel().getSelectionPaths();
        if (selectionPaths.length == 0) {
            return EMPTY_REMOTE_FILE_ARRAY;
        }
        HashSet<RemoteFile> remoteFileSet = new HashSet<RemoteFile>();
        for (int i = 0; i < selectionPaths.length; ++i) {
            RemoteFile[] files;
            SearchResultElement element;
            if (selectionPaths[i].getPathCount() == 3) {
                if (singleForAll) {
                    element = (SearchResultElement)selectionPaths[i].getPathComponent(1);
                    files = element.getRemoteFiles();
                    remoteFileSet.addAll(Arrays.asList(files));
                    continue;
                }
                RemoteFile remoteFile = (RemoteFile)selectionPaths[i].getPathComponent(2);
                remoteFileSet.add(remoteFile);
                continue;
            }
            element = (SearchResultElement)selectionPaths[i].getPathComponent(1);
            files = element.getRemoteFiles();
            remoteFileSet.addAll(Arrays.asList(files));
        }
        RemoteFile[] result = new RemoteFile[remoteFileSet.size()];
        remoteFileSet.toArray(result);
        return result;
    }

    @Override
    public void appendDGuiSettings(DGuiSettings dSettings) {
        super.appendDGuiSettings(dSettings);
        DTable dTable = GUIUtils.createDTable(this.searchTreeTable, PASSIVE_SEARCH_TABLE_IDENTIFIER);
        dSettings.getTableList().getTableList().add(dTable);
    }

    private class SearchTreeTableSelectionListener
    implements ListSelectionListener {
        private SearchTreeTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ResultMonitorTab.this.refreshTabActions();
            }
        }
    }

    private class TableHeaderMouseHandler
    extends MouseAdapter
    implements MouseListener {
        private TableHeaderMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            FWTableColumn column = ResultMonitorTab.this.searchTreeTable.getResizingColumn(e.getPoint());
            int clickCount = e.getClickCount();
            if (column == null && clickCount == 1) {
                this.handleColumnSorting(e);
            }
        }

        private void handleColumnSorting(MouseEvent e) {
            int viewIdx = ResultMonitorTab.this.searchTreeTable.getColumnModel().getColumnIndexAtX(e.getX());
            int modelIdx = ResultMonitorTab.this.searchTreeTable.convertColumnIndexToModel(viewIdx);
            if (modelIdx == -1) {
                return;
            }
            FWTableColumn column = (FWTableColumn)ResultMonitorTab.this.searchTreeTable.getColumnModel().getColumn(viewIdx);
            boolean isAscending = column.reverseSortingOrder();
            ResultMonitorTab.this.searchTreeTableModel.sortByColumn(modelIdx, isAscending);
        }
    }

    private class PassiveSearchHandler
    implements ActionListener {
        private FilteredQueryResponseMonitor monitor;

        private PassiveSearchHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.monitor == null) {
                this.monitor = new FilteredQueryResponseMonitor();
            }
            if (this.monitor.getPassiveSearchFilter() == null) {
                String searchStr = ResultMonitorTab.this.mPassiveSearch.getText().trim();
                SearchFilter filter = new SearchFilter();
                filter.updateSearchFilter(searchStr);
                this.monitor.updatePassiveSearchFilter(filter);
                Servent.getInstance().getMessageService().addMessageSubscriber(QueryResponseMsg.class, this.monitor);
                ResultMonitorTab.this.mPassiveButton.setText(Localizer.getString("ResultMonitorTab_StopPassiveSearch"));
            } else {
                this.monitor.updatePassiveSearchFilter(null);
                Servent.getInstance().getMessageService().removeMessageSubscriber(QueryResponseMsg.class, this.monitor);
                ResultMonitorTab.this.mPassiveButton.setText(Localizer.getString("ResultMonitorTab_StartPassiveSearch"));
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && e.getSource() == ResultMonitorTab.this.searchTreeTable) {
                ResultMonitorTab.this.getTabAction(ResultMonitorTab.QUICK_DOWNLOAD_ACTION_KEY).actionPerformed(null);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        private void popupMenu(Component source, int x, int y) {
            if (source == ResultMonitorTab.this.searchTreeTable || source == ResultMonitorTab.this.searchTreeTableScrollPane) {
                ResultMonitorTab.this.searchResultPopup.show(source, x, y);
            }
        }
    }

    private class AddToFavoritesAction
    extends FWAction {
        public AddToFavoritesAction() {
            super(Localizer.getString("AddToFavorites"), GUIRegistry.getInstance().getPlafIconPack().getIcon("ResultMonitor.FavoriteHost"), Localizer.getString("TTTAddToFavorites"));
            this.refreshActionState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RemoteFile[] files = ResultMonitorTab.this.getSelectedRemoteFiles(false);
            DestAddress[] addresses = new DestAddress[files.length];
            for (int i = 0; i < files.length; ++i) {
                addresses[i] = files[i].getHostAddress();
            }
            GUIActionPerformer.addHostsToFavorites(addresses);
        }

        @Override
        public void refreshActionState() {
            if (ResultMonitorTab.this.searchTreeTable.getSelectedRow() < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private final class BanHostActionProvider
    implements BanHostActionUtils.BanHostActionProvider {
        private BanHostActionProvider() {
        }

        @Override
        public DestAddress[] getBanHostAddresses() {
            RemoteFile[] files = ResultMonitorTab.this.getSelectedRemoteFiles(false);
            DestAddress[] addresses = new DestAddress[files.length];
            for (int i = 0; i < files.length; ++i) {
                addresses[i] = files[i].getHostAddress();
            }
            return addresses;
        }

        @Override
        public boolean isBanHostActionEnabled(boolean allowMultipleAddresses) {
            return ResultMonitorTab.this.searchTreeTable.getSelectedRow() >= 0 && (allowMultipleAddresses || ResultMonitorTab.this.searchTreeTable.getSelectedRowCount() <= 1);
        }
    }

    private class BrowseHostAction
    extends FWAction {
        public BrowseHostAction() {
            super(Localizer.getString("BrowseHost"), GUIRegistry.getInstance().getPlafIconPack().getIcon("ResultMonitor.BrowseHost"), Localizer.getString("TTTBrowseHost"));
            this.refreshActionState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RemoteFile rfile = ResultMonitorTab.this.getSelectedRemoteFile(false);
            if (rfile == null) {
                return;
            }
            if (!rfile.getQueryHitHost().isBrowseHostSupported()) {
                return;
            }
            GUIActionPerformer.browseHost(rfile.getHostAddress());
        }

        @Override
        public void refreshActionState() {
            RemoteFile rfile;
            if (ResultMonitorTab.this.searchTreeTable.getSelectedRowCount() == 1 && (rfile = ResultMonitorTab.this.getSelectedRemoteFile(false)) != null && rfile.getQueryHitHost().isBrowseHostSupported()) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ChatToHostAction
    extends FWAction {
        public ChatToHostAction() {
            super(Localizer.getString("ChatToHost"), GUIRegistry.getInstance().getPlafIconPack().getIcon("ResultMonitor.Chat"), Localizer.getString("TTTChatToHost"));
            this.refreshActionState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RemoteFile rfile = ResultMonitorTab.this.getSelectedRemoteFile(false);
            if (rfile == null) {
                return;
            }
            if (!rfile.getQueryHitHost().isChatSupported()) {
                return;
            }
            GUIActionPerformer.chatToHost(rfile.getHostAddress());
        }

        @Override
        public void refreshActionState() {
            RemoteFile rfile;
            if (ResultMonitorTab.this.searchTreeTable.getSelectedRowCount() == 1 && (rfile = ResultMonitorTab.this.getSelectedRemoteFile(false)) != null && rfile.getQueryHitHost().isChatSupported()) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ViewBitziTicketAction
    extends FWAction {
        public ViewBitziTicketAction() {
            super(Localizer.getString("ViewBitziTicket"), GUIRegistry.getInstance().getPlafIconPack().getIcon("ResultMonitor.ViewBitzi"), Localizer.getString("TTTViewBitziTicket"));
            this.refreshActionState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block3: {
                RemoteFile rfile = ResultMonitorTab.this.getSelectedRemoteFile(true);
                if (rfile == null) {
                    return;
                }
                String url = URLUtil.buildBitziLookupURL(rfile.getURN());
                try {
                    BrowserLauncher.openURL(url);
                }
                catch (IOException exp) {
                    NLogger.warn(ViewBitziTicketAction.class, (Object)exp, (Throwable)exp);
                    Object[] dialogOptions = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                    int choice = JOptionPane.showOptionDialog(ResultMonitorTab.this, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, dialogOptions, Localizer.getString("Yes"));
                    if (choice != 0) break block3;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(url), null);
                }
            }
        }

        @Override
        public void refreshActionState() {
            if (ResultMonitorTab.this.searchTreeTable.getSelectedRowCount() == 1) {
                RemoteFile rfile = ResultMonitorTab.this.getSelectedRemoteFile(true);
                if (rfile != null && rfile.getURN() != null) {
                    this.setEnabled(true);
                    return;
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class SWConfigDownloadAction
    extends FWAction {
        public SWConfigDownloadAction() {
            super(Localizer.getString("Download"), GUIRegistry.getInstance().getPlafIconPack().getIcon("ResultMonitor.ConfigDownload"), Localizer.getString("TTTDownload"));
            this.refreshActionState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwarmingManager swarmingMgr = SwarmingManager.getInstance();
            RemoteFile[] rfiles = ResultMonitorTab.this.getSelectedRemoteFiles(true);
            for (int i = 0; i < rfiles.length; ++i) {
                SWDownloadFile downloadFile = swarmingMgr.getDownloadFile(rfiles[i].getFileSize(), rfiles[i].getURN());
                if (downloadFile != null) {
                    downloadFile.addDownloadCandidate(rfiles[i]);
                    rfiles[i].setInDownloadQueue(true);
                    continue;
                }
                RemoteFile dfile = new RemoteFile(rfiles[i]);
                DownloadConfigDialog dialog = new DownloadConfigDialog(dfile);
                dialog.setVisible(true);
                if (!dfile.isInDownloadQueue()) continue;
                rfiles[i].setInDownloadQueue(true);
            }
        }

        @Override
        public void refreshActionState() {
            if (ResultMonitorTab.this.searchTreeTable.getSelectedRow() < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class SWQuickDownloadAction
    extends FWAction {
        public SWQuickDownloadAction() {
            super(Localizer.getString("QuickDownload"), GUIRegistry.getInstance().getPlafIconPack().getIcon("ResultMonitor.Download"), Localizer.getString("TTTQuickDownload"));
            this.refreshActionState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final RemoteFile[] rfiles = ResultMonitorTab.this.getSelectedRemoteFiles(true);
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    try {
                        SwarmingManager swarmingMgr = SwarmingManager.getInstance();
                        for (int i = 0; i < rfiles.length; ++i) {
                            rfiles[i].setInDownloadQueue(true);
                            SWDownloadFile downloadFile = swarmingMgr.getDownloadFile(rfiles[i].getFileSize(), rfiles[i].getURN());
                            if (downloadFile != null) {
                                downloadFile.addDownloadCandidate(rfiles[i]);
                                continue;
                            }
                            RemoteFile dfile = new RemoteFile(rfiles[i]);
                            String searchTerm = StringUtils.createNaturalSearchTerm(dfile.getFilename());
                            swarmingMgr.addFileToDownload(dfile, dfile.getFilename(), searchTerm);
                        }
                    }
                    catch (Throwable th) {
                        NLogger.error(SWQuickDownloadAction.class, (Object)th, th);
                    }
                }
            };
            ThreadPool.getInstance().addJob(runner, "QuickDownloadAction");
        }

        @Override
        public void refreshActionState() {
            if (ResultMonitorTab.this.searchTreeTable.getSelectedRow() < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }
}

