/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.monitor;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.download.RemoteFile;
import phex.gui.models.ISearchDataModel;
import phex.gui.models.SearchTreeTableModel;
import phex.gui.tabs.search.SearchResultElement;
import phex.gui.tabs.search.SearchResultElementComparator;
import phex.query.SearchDataEvent;
import phex.query.SearchFilter;
import phex.servent.Servent;

public class ResultMonitorDataModel
implements ISearchDataModel {
    private ArrayList<RemoteFile> allRemoteFiles = new ArrayList();
    private HashSet<String> allSearchResultSHA1Set = new HashSet();
    private int allSearchResultCount = 0;
    private ArrayList<SearchResultElement> displayedSearchResults = new ArrayList();
    private HashMap<String, SearchResultElement> displayedSearchResultSHA1Map = new HashMap();
    private SearchTreeTableModel visualizationModel;
    private SearchResultElementComparator comparator = new SearchResultElementComparator();
    protected SearchFilter searchFilter = null;

    public ResultMonitorDataModel() {
        Servent.getInstance().getEventService().processAnnotations(this);
    }

    @Override
    public int getSearchElementCount() {
        return this.displayedSearchResults.size();
    }

    public int getFilteredElementCount() {
        return this.allSearchResultCount - this.displayedSearchResults.size();
    }

    @Override
    public SearchResultElement getSearchElementAt(int index) {
        if (index < 0 || index >= this.displayedSearchResults.size()) {
            return null;
        }
        return this.displayedSearchResults.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSearchResults(Object[] newSearchResults) {
        ArrayList<RemoteFile> arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList<SearchResultElement> arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                for (int i = 0; i < newSearchResults.length; ++i) {
                    RemoteFile remoteFile = (RemoteFile)newSearchResults[i];
                    this.addSearchResultForDisplay(remoteFile);
                    this.addSearchResultToAll(remoteFile);
                }
            }
        }
    }

    private void addSearchResultToAll(RemoteFile remoteFile) {
        this.allRemoteFiles.add(remoteFile);
        String sha1 = remoteFile.getSHA1();
        boolean found = false;
        if (sha1 != null) {
            found = this.allSearchResultSHA1Set.contains(sha1);
        }
        if (!found) {
            ++this.allSearchResultCount;
            if (sha1 != null && sha1.length() > 0) {
                this.allSearchResultSHA1Set.add(sha1);
            }
        }
    }

    private void addSearchResultForDisplay(RemoteFile remoteFile) {
        boolean isFiltered = this.isFiltered(remoteFile);
        if (isFiltered) {
            return;
        }
        SearchResultElement resultElement = null;
        String sha1 = remoteFile.getSHA1();
        if (sha1 != null) {
            resultElement = this.displayedSearchResultSHA1Map.get(sha1);
        }
        if (resultElement != null) {
            resultElement.addRemoteFile(remoteFile);
            this.fireSearchResultAdded(remoteFile, resultElement);
        } else {
            resultElement = new SearchResultElement(remoteFile);
            int index = Collections.binarySearch(this.displayedSearchResults, resultElement, this.comparator);
            if (index <= 0) {
                if (sha1 != null && sha1.length() > 0) {
                    this.displayedSearchResultSHA1Map.put(sha1, resultElement);
                }
                this.displayedSearchResults.add(-index - 1, resultElement);
                this.fireNewSearchResultAdded(resultElement, -index - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSortBy(int sortField, boolean isSortedAscending) {
        ArrayList<SearchResultElement> arrayList = this.displayedSearchResults;
        synchronized (arrayList) {
            this.comparator.setSortField(sortField, isSortedAscending);
            Collections.sort(this.displayedSearchResults, this.comparator);
            this.fireAllSearchResultsChanged();
        }
    }

    @Override
    public void setVisualizationModel(SearchTreeTableModel model) {
        this.visualizationModel = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSearchFilter(SearchFilter aSearchFilter) {
        ArrayList<RemoteFile> arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList<SearchResultElement> arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                this.searchFilter = aSearchFilter;
                this.searchFilter.setLastTimeUsed(System.currentTimeMillis());
                this.updateFilteredQueryList();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSearchFilter() {
        ArrayList<RemoteFile> arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList<SearchResultElement> arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                this.searchFilter = null;
                this.updateFilteredQueryList();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSearchResults() {
        ArrayList<RemoteFile> arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList<SearchResultElement> arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                this.allRemoteFiles.clear();
                this.allSearchResultSHA1Set.clear();
                this.allSearchResultCount = 0;
                this.displayedSearchResults.clear();
                this.displayedSearchResultSHA1Map.clear();
                this.fireAllSearchResultsChanged();
            }
        }
    }

    public SearchFilter getSearchFilter() {
        return this.searchFilter;
    }

    private boolean isFiltered(RemoteFile remoteFile) {
        boolean isFiltered = false;
        if (this.searchFilter != null) {
            isFiltered = this.searchFilter.isFiltered(remoteFile);
        }
        return isFiltered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFilteredQueryList() {
        ArrayList<RemoteFile> arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList<SearchResultElement> arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                this.displayedSearchResultSHA1Map.clear();
                this.displayedSearchResults.clear();
                this.fireAllSearchResultsChanged();
                for (RemoteFile file : this.allRemoteFiles) {
                    this.addSearchResultForDisplay(file);
                }
            }
        }
    }

    @EventTopicSubscriber(topic="phex:search/monitor/results")
    public void onSearchDataEvent(String topic, SearchDataEvent event) {
        if (event.getType() == 1) {
            Object[] newSearchResults = event.getSearchData();
            this.addSearchResults(newSearchResults);
        }
    }

    private void fireAllSearchResultsChanged() {
        if (this.visualizationModel == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object[] path = new Object[]{ResultMonitorDataModel.this.visualizationModel.getRoot()};
                ResultMonitorDataModel.this.visualizationModel.fireTreeStructureChanged(ResultMonitorDataModel.this, path, null, null);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    private void fireNewSearchResultAdded(final SearchResultElement resultElement, final int index) {
        if (this.visualizationModel == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object[] path = new Object[]{ResultMonitorDataModel.this.visualizationModel.getRoot()};
                int[] indices = new int[]{index};
                Object[] changes = new Object[]{resultElement};
                if (ResultMonitorDataModel.this.displayedSearchResults.size() == 1) {
                    ResultMonitorDataModel.this.visualizationModel.fireTreeStructureChanged(ResultMonitorDataModel.this, path, indices, changes);
                } else {
                    ResultMonitorDataModel.this.visualizationModel.fireTreeNodesInserted(ResultMonitorDataModel.this, path, indices, changes);
                }
            }
        };
        runnable.run();
    }

    private void fireSearchResultAdded(final RemoteFile remoteFile, final SearchResultElement resultElement) {
        if (this.visualizationModel == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object[] path = new Object[]{ResultMonitorDataModel.this.visualizationModel.getRoot(), resultElement};
                Object[] changes = new Object[]{remoteFile};
                ResultMonitorDataModel.this.visualizationModel.fireTreeNodesInserted(ResultMonitorDataModel.this, path, null, changes);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }
}

