/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.monitor;

import java.awt.EventQueue;
import javax.swing.table.AbstractTableModel;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.host.Host;
import phex.msg.QueryMsg;
import phex.query.QueryHistoryMonitor;
import phex.servent.Servent;
import phex.utils.Localizer;

public class QueryHistoryMonitorTableModel
extends AbstractTableModel {
    private static final int numColRoutedFrom = 0;
    private static final int numColSearchText = 1;
    private static final int numColHopsTtl = 2;
    private static final String[] tableColumns = new String[]{Localizer.getString("SearchMonitorTab_RoutedFrom"), Localizer.getString("SearchMonitorTab_SearchText"), Localizer.getString("SearchMonitorTab_HopsTtl")};
    private QueryHistoryMonitor history;

    public QueryHistoryMonitorTableModel(QueryHistoryMonitor history) {
        this.history = history;
        Servent.getInstance().getEventService().processAnnotations(this);
    }

    @Override
    public String getColumnName(int col) {
        return tableColumns[col];
    }

    @Override
    public int getColumnCount() {
        return tableColumns.length;
    }

    @Override
    public int getRowCount() {
        return this.history.getHistorySize();
    }

    @Override
    public Object getValueAt(int row, int col) {
        QueryMsg searchQuery = this.history.getSearchQueryAt(row);
        if (searchQuery == null) {
            this.fireTableRowsDeleted(row, row);
            return null;
        }
        switch (col) {
            case 0: {
                Host fromHost = searchQuery.getHeader().getFromHost();
                if (fromHost == null) {
                    return "<Unknown>";
                }
                return fromHost.getHostAddress().getFullHostName();
            }
            case 1: {
                return searchQuery.getSearchString();
            }
            case 2: {
                byte hops = searchQuery.getHeader().getHopsTaken();
                int ttl = hops + searchQuery.getHeader().getTTL();
                return hops + " / " + ttl;
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return String.class;
    }

    @EventTopicSubscriber(topic="phex:query/monitor")
    public void onQueryMonitorEvent(String topic, Object event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryHistoryMonitorTableModel.this.fireTableDataChanged();
            }
        });
    }
}

