/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.filterpanel;

import javax.swing.table.AbstractTableModel;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.filterpanel.FilterListPanel;
import phex.rules.Rule;
import phex.rules.SearchFilterRules;
import phex.utils.Localizer;

public class FilterListTableModel
extends AbstractTableModel {
    private FilterListPanel filterListPanel;
    private SearchFilterRules rules;
    private SearchResultsDataModel displayedDataModel;

    public FilterListTableModel(FilterListPanel panel, SearchFilterRules rules) {
        this.filterListPanel = panel;
        this.rules = rules;
    }

    public void setDisplayedSearch(SearchResultsDataModel dataModel) {
        if (this.displayedDataModel != dataModel) {
            this.displayedDataModel = dataModel;
            this.fireTableDataChanged();
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.rules.getCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Rule rowRule = this.rules.getRuleAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                if (this.displayedDataModel == null) {
                    return Boolean.FALSE;
                }
                return this.displayedDataModel.isRuleActive(rowRule) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 1: {
                return this.rules.getRuleAt(rowIndex);
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 1: {
                return Localizer.getString("SearchTab_SelectRulesToActivate");
            }
        }
        return " ";
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Rule.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0 && this.displayedDataModel != null;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        Boolean boolVal = (Boolean)aValue;
        Rule rowRule = this.rules.getRuleAt(row);
        if (boolVal.booleanValue()) {
            this.displayedDataModel.activateRule(rowRule);
        } else {
            this.displayedDataModel.deactivateRule(rowRule);
        }
    }
}

