/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.filterpanel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import phex.gui.actions.FWAction;
import phex.gui.common.table.FWTable;
import phex.gui.dialogs.filter.AdvSearchRulesDialog;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.filterpanel.FilterListTableModel;
import phex.rules.Rule;
import phex.rules.SearchFilterRules;
import phex.utils.Localizer;

public class FilterListPanel
extends JPanel {
    private final SearchFilterRules filterRules;
    private FilterListTableModel filterListTableModel;
    private FWTable searchRuleTable;

    public FilterListPanel(SearchFilterRules rules) {
        this.filterRules = rules;
        this.initializeComponent();
        this.updateUI();
    }

    private void initializeComponent() {
        this.setOpaque(false);
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("18dlu, fill:d:grow, 2dlu, d, 6dlu", "6dlu, p, 6dlu,");
        PanelBuilder panelBuilder = new PanelBuilder(layout, this);
        this.filterListTableModel = new FilterListTableModel(this, this.filterRules);
        this.searchRuleTable = new FWTable(this.filterListTableModel);
        this.searchRuleTable.setVisibleRowCount(3);
        this.searchRuleTable.setShowVerticalLines(false);
        JTableHeader tableHeader = this.searchRuleTable.getTableHeader();
        tableHeader.setResizingAllowed(false);
        tableHeader.setReorderingAllowed(false);
        JCheckBox box = (JCheckBox)((Object)this.searchRuleTable.getDefaultRenderer(Boolean.class));
        TableColumn column = this.searchRuleTable.getColumnModel().getColumn(0);
        column.setMaxWidth(box.getPreferredSize().width + 2);
        column.setMinWidth(box.getPreferredSize().width + 2);
        TableCellRenderer headerRenderer = this.searchRuleTable.getTableHeader().getDefaultRenderer();
        if (headerRenderer instanceof JLabel) {
            ((JLabel)((Object)headerRenderer)).setHorizontalAlignment(2);
        }
        column = this.searchRuleTable.getColumnModel().getColumn(1);
        column.setCellRenderer(new RuleCellRenderer());
        JScrollPane scrollPane = FWTable.createFWTableScrollPane(this.searchRuleTable);
        panelBuilder.add((Component)scrollPane, cc.xy(2, 2));
        JButton btn = new JButton(new AdvancedFilterAction());
        panelBuilder.add((Component)btn, cc.xy(4, 2));
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        if (searchResultsDataModel == null) {
            this.searchRuleTable.setEnabled(false);
            this.searchRuleTable.clearSelection();
        } else {
            this.searchRuleTable.setEnabled(true);
        }
        this.filterListTableModel.setDisplayedSearch(searchResultsDataModel);
    }

    private class AdvancedFilterAction
    extends FWAction {
        public AdvancedFilterAction() {
            super(Localizer.getString("SearchTab_EditFilterRules"), null, Localizer.getString("SearchTab_TTTEditFilterRules"));
            this.refreshActionState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new AdvSearchRulesDialog(FilterListPanel.this.filterRules).setVisible(true);
        }

        @Override
        public void refreshActionState() {
            this.setEnabled(true);
        }
    }

    public class RuleCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Rule) {
                this.setText(((Rule)value).getName());
            }
            return this;
        }
    }
}

