/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.cp;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;
import phex.gui.common.BoxPanel;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.PhexColors;
import phex.gui.tabs.search.SearchTab;
import phex.gui.tabs.search.cp.SearchControlPanel;
import phex.utils.Localizer;

public class SearchActivityBox
extends BoxPanel {
    private static Border ROLLOVER_BUTTON_BORDER = new CompoundBorder(GUIUtils.ROLLOVER_BUTTON_BORDER, new EmptyBorder(2, 2, 2, 2));
    private static ButtonUI ACTIVITY_BUTTON_UI = new ActivityButtonUI();
    private JPanel newSearchActivityP;
    private JToggleButton keywordSearchBtn;
    private JToggleButton whatsNewBtn;
    private JToggleButton browseHostBtn;
    private JPanel runningSearchActivityP;
    private JButton newSearchBtn;
    private JButton closeSearchBtn;

    public SearchActivityBox(SearchTab searchTab, final SearchControlPanel cp) {
        super(Localizer.getString("SearchTab_SearchActivity"));
        CellConstraints cc = new CellConstraints();
        this.getContentPanel().setLayout(new BorderLayout());
        this.newSearchActivityP = new JPanel();
        this.newSearchActivityP.setOpaque(false);
        this.getContentPanel().add((Component)this.newSearchActivityP, "Center");
        FormLayout newSearchLayout = new FormLayout("6dlu, fill:p:grow, 6dlu", "2dlu, p, 1dlu, p, 1dlu, p, 2dlu");
        PanelBuilder newSearchBuilder = new PanelBuilder(newSearchLayout, this.newSearchActivityP);
        this.keywordSearchBtn = new JToggleButton(Localizer.getString("SearchTab_KeywordSearch"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.Search"));
        this.keywordSearchBtn.setToolTipText(Localizer.getString("SearchTab_TTTKeywordSearch"));
        this.updateActivityBtnProps(this.keywordSearchBtn);
        this.keywordSearchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cp.activateKeywordSearchBox();
            }
        });
        this.whatsNewBtn = new JToggleButton(Localizer.getString("SearchTab_WhatsNew"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.WhatsNewSearch"));
        this.whatsNewBtn.setToolTipText(Localizer.getString("SearchTab_TTTWhatsNew"));
        this.updateActivityBtnProps(this.whatsNewBtn);
        this.whatsNewBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cp.activateWhatsNewBox();
            }
        });
        this.browseHostBtn = new JToggleButton(Localizer.getString("SearchTab_BrowseHost"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.BrowseHost"));
        this.browseHostBtn.setToolTipText(Localizer.getString("SearchTab_TTTBrowseHost"));
        this.updateActivityBtnProps(this.browseHostBtn);
        this.browseHostBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cp.activateBrowseHostBox();
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.keywordSearchBtn);
        group.add(this.whatsNewBtn);
        group.add(this.browseHostBtn);
        newSearchBuilder.add((Component)this.keywordSearchBtn, cc.xy(2, 2));
        newSearchBuilder.add((Component)this.whatsNewBtn, cc.xy(2, 4));
        newSearchBuilder.add((Component)this.browseHostBtn, cc.xy(2, 6));
        this.runningSearchActivityP = new JPanel();
        this.runningSearchActivityP.setOpaque(false);
        FormLayout runningLayout = new FormLayout("6dlu, fill:p:grow, 6dlu", "2dlu, p, 1dlu, p, 2dlu");
        PanelBuilder runningBuilder = new PanelBuilder(runningLayout, this.runningSearchActivityP);
        this.newSearchBtn = new JButton(Localizer.getString("SearchTab_NewSearch"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.Search"));
        this.newSearchBtn.setToolTipText(Localizer.getString("SearchTab_TTTNewSearch"));
        this.newSearchBtn.addActionListener(searchTab.getTabAction("CreateNewSearchAction"));
        this.updateActivityBtnProps(this.newSearchBtn);
        this.closeSearchBtn = new JButton(Localizer.getString("SearchTab_CloseSearch"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.Close"));
        this.closeSearchBtn.setToolTipText(Localizer.getString("SearchTab_TTTCloseSearch"));
        this.closeSearchBtn.addActionListener(searchTab.getTabAction("CloseSearchAction"));
        this.updateActivityBtnProps(this.closeSearchBtn);
        runningBuilder.add((Component)this.newSearchBtn, cc.xy(2, 2));
        runningBuilder.add((Component)this.closeSearchBtn, cc.xy(2, 4));
    }

    public void postInit() {
        this.keywordSearchBtn.doClick();
    }

    public void displayRunningSearchPanel() {
        JPanel activityContentP = this.getContentPanel();
        activityContentP.removeAll();
        activityContentP.add((Component)this.runningSearchActivityP, "Center");
        activityContentP.doLayout();
        activityContentP.revalidate();
        activityContentP.repaint();
        this.newSearchBtn.getModel().setRollover(false);
        this.closeSearchBtn.getModel().setRollover(false);
    }

    public void displayNewSearchPanel() {
        JPanel activityContentP = this.getContentPanel();
        activityContentP.removeAll();
        activityContentP.add((Component)this.newSearchActivityP, "Center");
        activityContentP.doLayout();
        activityContentP.revalidate();
        activityContentP.repaint();
        this.keywordSearchBtn.doClick();
    }

    private void updateActivityBtnProps(AbstractButton b) {
        b.setUI(ACTIVITY_BUTTON_UI);
        b.setIconTextGap(8);
        b.setHorizontalAlignment(2);
        b.setCursor(Cursor.getPredefinedCursor(12));
        b.setBorder(ROLLOVER_BUTTON_BORDER);
        b.setRolloverEnabled(true);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.keywordSearchBtn != null) {
            this.keywordSearchBtn.setUI(ACTIVITY_BUTTON_UI);
        }
        if (this.whatsNewBtn != null) {
            this.whatsNewBtn.setUI(ACTIVITY_BUTTON_UI);
        }
        if (this.browseHostBtn != null) {
            this.browseHostBtn.setUI(ACTIVITY_BUTTON_UI);
        }
    }

    private static class ActivityButtonUI
    extends BasicButtonUI {
        private Color fromColor = PhexColors.getBoxPanelBackground().darker();
        private Color toColor = PhexColors.getBoxPanelBackground().brighter();

        private ActivityButtonUI() {
        }

        @Override
        public void update(Graphics g, JComponent c) {
            if (c.isOpaque()) {
                g.setColor(PhexColors.getBoxPanelBackground());
                int width = c.getWidth();
                int height = c.getHeight();
                g.fillRect(0, 0, width, height);
                AbstractButton b = (AbstractButton)c;
                if (b.isSelected()) {
                    GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.fromColor, width / 2, height / 2, this.toColor, true);
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setPaint(gradient);
                    g2.fillRect(0, 0, width, height);
                }
            }
            this.paint(g, c);
        }
    }
}

