/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.download.RemoteFile;
import phex.event.ContainerEvent;
import phex.gui.models.ISearchDataModel;
import phex.gui.models.SearchTreeTableModel;
import phex.gui.tabs.search.SearchResultElement;
import phex.gui.tabs.search.SearchResultElementComparator;
import phex.query.Search;
import phex.query.SearchDataEvent;
import phex.rules.Rule;
import phex.rules.SearchFilterRules;
import phex.security.HittingIpCidrPair;
import phex.security.IpUserSecurityRule;
import phex.security.SecurityRule;
import phex.servent.Servent;

public class SearchResultsDataModel
implements ISearchDataModel {
    private static final HashMap<Search, SearchResultsDataModel> searchToDataModelMap = new HashMap();
    private ArrayList<RemoteFile> allRemoteFiles;
    private HashSet<String> allSearchResultSHA1Set;
    private int allSearchResultCount;
    private ArrayList<SearchResultElement> displayedSearchResults;
    private HashMap<String, SearchResultElement> displayedSearchResultSHA1Map;
    private SearchTreeTableModel visualizationModel;
    private SearchResultElementComparator comparator;
    private Search search;
    private Rule quickFilterRule;
    private Set<Rule> searchFilterRuleSet;

    private SearchResultsDataModel(Search search, SearchFilterRules filterRules) {
        this.search = search;
        this.allRemoteFiles = new ArrayList();
        this.allSearchResultSHA1Set = new HashSet();
        this.allSearchResultCount = 0;
        this.displayedSearchResults = new ArrayList();
        this.displayedSearchResultSHA1Map = new HashMap();
        this.comparator = new SearchResultElementComparator();
        this.searchFilterRuleSet = new HashSet<Rule>();
        this.searchFilterRuleSet.addAll(filterRules.getPermanentList());
        Servent.getInstance().getEventService().processAnnotations(this);
    }

    @Override
    public int getSearchElementCount() {
        return this.displayedSearchResults.size();
    }

    public int getAllSearchResultCount() {
        return this.allSearchResultCount;
    }

    public int getFilteredElementCount() {
        return this.allSearchResultCount - this.displayedSearchResults.size();
    }

    @Override
    public SearchResultElement getSearchElementAt(int index) {
        if (index < 0 || index >= this.displayedSearchResults.size()) {
            return null;
        }
        return this.displayedSearchResults.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSearchResults(RemoteFile[] newSearchResults, boolean fireEvents) {
        this.processFilterRules(newSearchResults);
        ArrayList<RemoteFile> arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList<SearchResultElement> arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                for (int i = 0; i < newSearchResults.length; ++i) {
                    RemoteFile remoteFile = newSearchResults[i];
                    if (remoteFile.isFilteredRemoved()) continue;
                    if (!remoteFile.isFilteredHidden()) {
                        this.addSearchResultForDisplay(remoteFile, fireEvents);
                    }
                    this.addSearchResultToAll(remoteFile);
                }
            }
        }
    }

    private void addSearchResultToAll(RemoteFile remoteFile) {
        this.allRemoteFiles.add(remoteFile);
        String sha1 = remoteFile.getSHA1();
        boolean found = false;
        if (sha1 != null) {
            found = this.allSearchResultSHA1Set.contains(sha1);
        }
        if (!found) {
            ++this.allSearchResultCount;
            if (sha1 != null && sha1.length() > 0) {
                this.allSearchResultSHA1Set.add(sha1);
            }
        }
    }

    private void addSearchResultForDisplay(RemoteFile remoteFile, boolean fireEvents) {
        SearchResultElement resultElement = null;
        String sha1 = remoteFile.getSHA1();
        if (sha1 != null) {
            resultElement = this.displayedSearchResultSHA1Map.get(sha1);
        }
        if (resultElement != null) {
            resultElement.addRemoteFile(remoteFile);
            if (fireEvents) {
                this.fireSearchResultAdded(remoteFile, resultElement);
            }
        } else {
            resultElement = new SearchResultElement(remoteFile);
            int index = Collections.binarySearch(this.displayedSearchResults, resultElement, this.comparator);
            if (index <= 0) {
                if (sha1 != null && sha1.length() > 0) {
                    this.displayedSearchResultSHA1Map.put(sha1, resultElement);
                }
                this.displayedSearchResults.add(-index - 1, resultElement);
                if (fireEvents) {
                    this.fireNewSearchResultAdded(resultElement, -index - 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSortBy(int sortField, boolean isSortedAscending) {
        ArrayList<SearchResultElement> arrayList = this.displayedSearchResults;
        synchronized (arrayList) {
            this.comparator.setSortField(sortField, isSortedAscending);
            Collections.sort(this.displayedSearchResults, this.comparator);
            this.fireAllSearchResultsChanged();
        }
    }

    @Override
    public void setVisualizationModel(SearchTreeTableModel model) {
        this.visualizationModel = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSearchResults() {
        ArrayList<RemoteFile> arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList<SearchResultElement> arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                this.allRemoteFiles.clear();
                this.allSearchResultSHA1Set.clear();
                this.allSearchResultCount = 0;
                this.displayedSearchResults.clear();
                this.displayedSearchResultSHA1Map.clear();
                this.fireAllSearchResultsChanged();
                this.search.fireSearchChanged();
            }
        }
    }

    public Search getSearch() {
        return this.search;
    }

    public Rule getQuickFilterRule() {
        return this.quickFilterRule;
    }

    public void setQuickFilterRule(Rule rule) {
        this.quickFilterRule = rule;
        this.updateFilteredQueryList();
    }

    public boolean isRuleActive(Rule rule) {
        return this.searchFilterRuleSet.contains(rule);
    }

    public void activateRule(Rule rule) {
        this.searchFilterRuleSet.add(rule);
        this.updateFilteredQueryList();
    }

    public void deactivateRule(Rule rule) {
        this.searchFilterRuleSet.remove(rule);
        this.updateFilteredQueryList();
    }

    private void processFilterRules(RemoteFile[] remoteFiles) {
        if (this.searchFilterRuleSet == null) {
            return;
        }
        if (this.quickFilterRule != null) {
            this.quickFilterRule.process(this.search, remoteFiles);
        }
        for (Rule rule : this.searchFilterRuleSet) {
            rule.process(this.search, remoteFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFilteredQueryList() {
        ArrayList<RemoteFile> arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList<SearchResultElement> arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                RemoteFile[] remoteFiles = new RemoteFile[this.allRemoteFiles.size()];
                this.allRemoteFiles.toArray(remoteFiles);
                this.allSearchResultCount = 0;
                this.allRemoteFiles.clear();
                this.allSearchResultSHA1Set.clear();
                this.displayedSearchResultSHA1Map.clear();
                this.displayedSearchResults.clear();
                this.fireAllSearchResultsChanged();
                for (int i = 0; i < remoteFiles.length; ++i) {
                    remoteFiles[i].clearFilterFlags();
                }
                this.addSearchResults(remoteFiles, true);
                this.search.fireSearchChanged();
            }
        }
    }

    public void release() {
        this.visualizationModel = null;
        this.clearSearchResults();
    }

    @EventTopicSubscriber(topic="phex:search/data")
    public void onSearchDataEvent(String topic, SearchDataEvent event) {
        if (this.search != event.getSource()) {
            return;
        }
        if (event.getType() == 1) {
            RemoteFile[] newSearchResults = event.getSearchData();
            this.addSearchResults(newSearchResults, true);
        }
    }

    public String toString() {
        return super.toString() + " - " + this.search;
    }

    @EventTopicSubscriber(topic="phex:security/rule")
    public void onSecurityRuleEvent(String topic, ContainerEvent event) {
        final SecurityRule rule = (SecurityRule)event.getSource();
        if (event.getType() == ContainerEvent.Type.ADDED) {
            if (rule.isDisabled()) {
                return;
            }
            if (rule instanceof IpUserSecurityRule) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        SearchResultsDataModel.this.updateSecurityFilteredQueryList((IpUserSecurityRule)rule);
                    }
                };
                EventQueue.invokeLater(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSecurityFilteredQueryList(IpUserSecurityRule rule) {
        ArrayList<RemoteFile> arrayList = this.allRemoteFiles;
        synchronized (arrayList) {
            ArrayList<SearchResultElement> arrayList2 = this.displayedSearchResults;
            synchronized (arrayList2) {
                ArrayList<RemoteFile> remoteFilesList = new ArrayList<RemoteFile>(this.allRemoteFiles);
                this.allSearchResultCount = 0;
                this.allRemoteFiles.clear();
                this.allSearchResultSHA1Set.clear();
                this.displayedSearchResultSHA1Map.clear();
                this.displayedSearchResults.clear();
                this.fireAllSearchResultsChanged();
                HittingIpCidrPair rulePair = rule.getIpCidrPair();
                ListIterator iterator = remoteFilesList.listIterator();
                while (iterator.hasNext()) {
                    RemoteFile remoteFile = (RemoteFile)iterator.next();
                    DestAddress address = remoteFile.getHostAddress();
                    IpAddress ipAddress = address.getIpAddress();
                    if (ipAddress != null && rulePair.contains(AddressUtils.byteIpToIntIp(ipAddress.getHostIP()), -1)) {
                        rulePair.countHit();
                        iterator.remove();
                        continue;
                    }
                    remoteFile.clearFilterFlags();
                }
                RemoteFile[] remoteFiles = new RemoteFile[remoteFilesList.size()];
                remoteFilesList.toArray(remoteFiles);
                this.addSearchResults(remoteFiles, false);
                this.fireAllSearchResultsChanged();
                this.search.fireSearchChanged();
            }
        }
    }

    private void fireAllSearchResultsChanged() {
        if (this.visualizationModel == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object[] path = new Object[]{SearchResultsDataModel.this.visualizationModel.getRoot()};
                SearchResultsDataModel.this.visualizationModel.fireTreeStructureChanged(SearchResultsDataModel.this, path, null, null);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    private void fireNewSearchResultAdded(final SearchResultElement resultElement, final int index) {
        if (this.visualizationModel == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object[] path = new Object[]{SearchResultsDataModel.this.visualizationModel.getRoot()};
                int[] indices = new int[]{index};
                Object[] changes = new Object[]{resultElement};
                if (SearchResultsDataModel.this.displayedSearchResults.size() == 1) {
                    SearchResultsDataModel.this.visualizationModel.fireTreeStructureChanged(SearchResultsDataModel.this, path, indices, changes);
                } else {
                    SearchResultsDataModel.this.visualizationModel.fireTreeNodesInserted(SearchResultsDataModel.this, path, indices, changes);
                }
            }
        };
        runnable.run();
    }

    private void fireSearchResultAdded(final RemoteFile remoteFile, final SearchResultElement resultElement) {
        if (this.visualizationModel == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object[] path = new Object[]{SearchResultsDataModel.this.visualizationModel.getRoot(), resultElement};
                Object[] changes = new Object[]{remoteFile};
                SearchResultsDataModel.this.visualizationModel.fireTreeNodesInserted(SearchResultsDataModel.this, path, null, changes);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    public static SearchResultsDataModel registerNewSearch(Search search, SearchFilterRules filterRules) {
        SearchResultsDataModel dataModel = new SearchResultsDataModel(search, filterRules);
        searchToDataModelMap.put(search, dataModel);
        return dataModel;
    }

    public static SearchResultsDataModel lookupResultDataModel(Search search) {
        return searchToDataModelMap.get(search);
    }

    public static void unregisterSearch(Search search) {
        SearchResultsDataModel dataModel = searchToDataModelMap.remove(search);
        if (dataModel != null) {
            dataModel.release();
        }
    }
}

