/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import java.util.ArrayList;
import java.util.List;
import phex.common.ShortObj;
import phex.common.format.HostSpeedFormatUtils;
import phex.download.RemoteFile;
import phex.utils.Localizer;

public class SearchResultElement {
    private RemoteFile remoteFile;
    private List<RemoteFile> remoteFileList;
    private ShortObj bestScore;
    private ShortObj bestRating;
    private int bestSpeed;
    private String cachedBestSpeedFormatted;

    public SearchResultElement(RemoteFile aRemoteFile) {
        this.remoteFile = aRemoteFile;
        this.bestScore = new ShortObj(this.remoteFile.getScore());
        this.bestRating = new ShortObj(this.remoteFile.getQueryHitHost().getHostRating());
        this.bestSpeed = this.remoteFile.getSpeed();
        this.cachedBestSpeedFormatted = null;
        this.remoteFileList = new ArrayList<RemoteFile>(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteFile(RemoteFile aRemoteFile) {
        List<RemoteFile> list = this.remoteFileList;
        synchronized (list) {
            if (this.remoteFileList.size() == 0) {
                this.remoteFileList.add(this.remoteFile);
            }
            this.remoteFileList.add(aRemoteFile);
            if (aRemoteFile.getScore() > this.bestScore.value) {
                this.bestScore.value = aRemoteFile.getScore();
            }
            if (aRemoteFile.getQueryHitHost().getHostRating() > this.bestRating.value) {
                this.bestRating.value = aRemoteFile.getQueryHitHost().getHostRating();
            }
            if (aRemoteFile.getSpeed() > this.bestSpeed) {
                this.bestSpeed = aRemoteFile.getSpeed();
                this.cachedBestSpeedFormatted = null;
            }
        }
    }

    public int getRemoteFileListCount() {
        return this.remoteFileList.size();
    }

    public RemoteFile getRemoteFileAt(int index) {
        if (index < 0 || index >= this.remoteFileList.size()) {
            return null;
        }
        return this.remoteFileList.get(index);
    }

    public RemoteFile getSingleRemoteFile() {
        return this.remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFile[] getRemoteFiles() {
        if (this.remoteFileList.size() == 0) {
            return new RemoteFile[]{this.remoteFile};
        }
        List<RemoteFile> list = this.remoteFileList;
        synchronized (list) {
            RemoteFile[] remoteFiles = new RemoteFile[this.remoteFileList.size()];
            this.remoteFileList.toArray(remoteFiles);
            return remoteFiles;
        }
    }

    public Object getValue(int modelIndex) {
        switch (modelIndex) {
            case 3: {
                return this.bestScore;
            }
            case 4: {
                return this.bestRating;
            }
            case 6: {
                int listSize = this.remoteFileList.size();
                if (this.remoteFileList.size() > 0) {
                    return Localizer.getFormatedString("NumberOfHosts", new Integer(listSize));
                }
                return this.remoteFile.getHostAddress();
            }
            case 7: {
                int listSize = this.remoteFileList.size();
                if (this.remoteFileList.size() > 0) {
                    return Localizer.getFormatedString("NumberOfHosts", new Integer(listSize));
                }
                return this.remoteFile.getQueryHitHost().getVendor();
            }
        }
        return "";
    }

    public String getFormattedHostSpeed() {
        if (this.cachedBestSpeedFormatted == null) {
            this.cachedBestSpeedFormatted = HostSpeedFormatUtils.formatHostSpeed(this.bestSpeed);
        }
        return this.cachedBestSpeedFormatted;
    }
}

