/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import phex.common.log.NLogger;
import phex.gui.actions.FWAction;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.tabs.search.SearchListTableModel;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchTab;
import phex.query.Search;
import phex.query.SearchContainer;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;

public class SearchListPanel
extends JPanel {
    private static final String SEARCHLIST_TABLE_IDENTIFIER = "SearchListTable";
    private SearchContainer searchContainer;
    private SearchTab searchTab;
    private FWTable searchListTable;
    private JScrollPane searchListTableScrollPane;
    private SearchListTableModel searchListModel;
    private JPopupMenu searchListPopup;

    public SearchListPanel(SearchTab tab, SearchContainer searchContainer) {
        this.searchContainer = searchContainer;
        this.searchTab = tab;
    }

    public void initializeComponent(DGuiSettings guiSettings) {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("fill:d:grow", "fill:d:grow");
        PanelBuilder panelBuilder = new PanelBuilder(layout, this);
        MouseHandler mouseHandler = new MouseHandler();
        this.searchListModel = new SearchListTableModel(this.searchContainer);
        this.searchListModel.addTableModelListener(new SearchListTableListener());
        this.searchListTable = new FWTable(new FWSortedTableModel(this.searchListModel));
        GUIUtils.updateTableFromDGuiSettings(guiSettings, this.searchListTable, SEARCHLIST_TABLE_IDENTIFIER);
        this.searchListTable.setSelectionMode(0);
        this.searchListTable.activateAllHeaderActions();
        this.searchListTable.setAutoResizeMode(0);
        this.searchListTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.searchListTable.addMouseListener(mouseHandler);
        GUIRegistry.getInstance().getGuiUpdateTimer().addTable(this.searchListTable);
        this.searchListTableScrollPane = FWTable.createFWTableScrollPane(this.searchListTable);
        this.searchListTableScrollPane.addMouseListener(mouseHandler);
        panelBuilder.add((Component)this.searchListTableScrollPane, cc.xy(1, 1));
        this.searchListPopup = new JPopupMenu();
        this.searchListPopup.add(this.searchTab.getTabAction("CreateNewSearchAction"));
        this.searchListPopup.add(this.searchTab.getTabAction("ClearSearchResultsAction"));
        FWAction closeSearchAction = this.searchTab.getTabAction("CloseSearchAction");
        this.searchListPopup.add(closeSearchAction);
        this.searchListTable.getActionMap().put("CloseSearchAction", closeSearchAction);
        this.searchListTable.getInputMap(1).put((KeyStroke)closeSearchAction.getValue("AcceleratorKey"), "CloseSearchAction");
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        if (searchResultsDataModel == null) {
            this.searchListTable.getSelectionModel().clearSelection();
            return;
        }
        int modelRow = this.searchContainer.getIndexOfSearch(searchResultsDataModel.getSearch());
        if (modelRow != -1) {
            int viewRow = this.searchListTable.translateRowIndexToView(modelRow);
            if (viewRow != -1) {
                this.searchListTable.getSelectionModel().setSelectionInterval(viewRow, viewRow);
            } else {
                this.searchListTable.getSelectionModel().clearSelection();
            }
        } else {
            this.searchListTable.getSelectionModel().clearSelection();
        }
    }

    private Search getSelectedSearch() {
        int viewRow = this.searchListTable.getSelectedRow();
        if (viewRow < 0) {
            return null;
        }
        int modelRow = this.searchListTable.translateRowIndexToModel(viewRow);
        Search search = this.searchContainer.getSearchAt(modelRow);
        return search;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        pref.height = (int)((double)this.searchListTable.getRowHeight() * 4.7);
        return pref;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.searchListTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.searchListTableScrollPane);
        }
    }

    public void appendDGuiSettings(DGuiSettings dSettings) {
        DTable dTable = GUIUtils.createDTable(this.searchListTable, SEARCHLIST_TABLE_IDENTIFIER);
        dSettings.getTableList().getTableList().add(dTable);
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                if (e.getClickCount() == 2 && e.getSource() == SearchListPanel.this.searchListTableScrollPane) {
                    SearchListPanel.this.searchTab.setDisplayedSearch(null);
                }
            }
            catch (Throwable th) {
                NLogger.error(MouseHandler.class, (Object)th, th);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        private void popupMenu(Component source, int x, int y) {
            if (source == SearchListPanel.this.searchListTable || source == SearchListPanel.this.searchListTableScrollPane) {
                SearchListPanel.this.searchTab.refreshTabActions();
                SearchListPanel.this.searchListPopup.show(source, x, y);
            }
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            try {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SearchListPanel.this.searchTab.refreshTabActions();
                Search search = SearchListPanel.this.getSelectedSearch();
                if (search == null) {
                    return;
                }
                SearchResultsDataModel dataModel = SearchResultsDataModel.lookupResultDataModel(search);
                SearchListPanel.this.searchTab.setDisplayedSearch(dataModel);
            }
            catch (Exception exp) {
                NLogger.error(SelectionHandler.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    private class SearchListTableListener
    implements TableModelListener {
        private SearchListTableListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 1) {
                Search search = SearchListPanel.this.searchContainer.getSearchAt(e.getFirstRow());
                SearchResultsDataModel dataModel = SearchResultsDataModel.lookupResultDataModel(search);
                SearchListPanel.this.searchTab.setDisplayedSearch(dataModel);
            }
        }
    }
}

