/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.address.DestAddress;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IconPack;
import phex.gui.common.PhexColors;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchTab;
import phex.query.BrowseHostResults;
import phex.query.KeywordSearch;
import phex.query.Search;
import phex.query.SearchDataEvent;
import phex.query.WhatsNewSearch;
import phex.servent.Servent;
import phex.utils.Localizer;

public class SearchButton
extends JToggleButton {
    private Search search;
    private SearchTab searchTab;

    public SearchButton(Search search, SearchTab searchTab) {
        this.search = search;
        this.searchTab = searchTab;
        this.updateButtonDisplay();
        this.setUI(new SearchButtonUI());
        this.setBorder(GUIUtils.ROLLOVER_BUTTON_BORDER);
        this.setRolloverEnabled(true);
        this.setHorizontalAlignment(2);
        this.setMargin(GUIUtils.EMPTY_INSETS);
        Servent.getInstance().getEventService().processAnnotations(this);
    }

    public Search getSearch() {
        return this.search;
    }

    public void updateButtonDisplay() {
        StringBuffer textBuf = new StringBuffer();
        if (this.search instanceof KeywordSearch) {
            textBuf.append(((KeywordSearch)this.search).getSearchString());
            this.setIcon(GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.Search"));
        } else if (this.search instanceof BrowseHostResults) {
            DestAddress destAddress = ((BrowseHostResults)this.search).getDestAddress();
            textBuf.append(destAddress.getFullHostName());
            this.setIcon(GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.BrowseHost"));
        } else if (this.search instanceof WhatsNewSearch) {
            textBuf.append(Localizer.getString("SearchTab_WhatsNewSearch"));
            this.setIcon(IconPack.EMPTY_IMAGE_16);
        } else {
            textBuf.append(this.search.toString());
            this.setIcon(IconPack.EMPTY_IMAGE_16);
        }
        SearchResultsDataModel dataModel = SearchResultsDataModel.lookupResultDataModel(this.search);
        int dispElem = 0;
        int filteredElem = 0;
        if (dataModel != null) {
            dispElem = dataModel.getSearchElementCount();
            filteredElem = dataModel.getFilteredElementCount();
        }
        textBuf.append(" (");
        textBuf.append(dispElem);
        if (filteredElem > 0) {
            textBuf.append("/").append(filteredElem);
        }
        textBuf.append(")");
        this.setText(textBuf.toString());
    }

    @EventTopicSubscriber(topic="phex:search/data")
    public void onSearchDataEvent(String topic, SearchDataEvent event) {
        if (this.search != event.getSource()) {
            return;
        }
        this.updateButtonDisplay();
    }

    private static class SearchButtonUI
    extends BasicButtonUI {
        private static final Icon closeIcon = GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.Close");
        private Color fromColor = PhexColors.getBoxPanelBackground().darker();
        private Color toColor = PhexColors.getBoxPanelBackground().brighter();
        private static Rectangle viewRect = new Rectangle();
        private static Rectangle displayRect = new Rectangle();
        private static Rectangle textRect = new Rectangle();
        private static Rectangle iconRect = new Rectangle();

        private SearchButtonUI() {
        }

        @Override
        public Dimension getMinimumSize(JComponent c) {
            Dimension dim = super.getMinimumSize(c);
            dim.width = 0;
            return dim;
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            Dimension dim = super.getPreferredSize(c);
            dim.width = Math.max(150, dim.width + closeIcon.getIconWidth());
            return dim;
        }

        @Override
        public void update(Graphics g, JComponent c) {
            if (c.isOpaque()) {
                g.setColor(c.getBackground());
                int width = c.getWidth();
                int height = c.getHeight();
                g.fillRect(0, 0, width, height);
                AbstractButton b = (AbstractButton)c;
                if (b.isSelected()) {
                    GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.fromColor, width / 2, height / 2, this.toColor, true);
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setPaint(gradient);
                    g2.fillRect(0, 0, width, height);
                }
            }
            this.paint(g, c);
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            FontMetrics fm = b.getFontMetrics(g.getFont());
            Insets i = c.getInsets();
            SearchButtonUI.displayRect.x = SearchButtonUI.viewRect.x = i.left;
            SearchButtonUI.displayRect.y = SearchButtonUI.viewRect.y = i.top;
            SearchButtonUI.viewRect.width = b.getWidth() - (i.right + SearchButtonUI.viewRect.x);
            SearchButtonUI.displayRect.width = b.isSelected() ? SearchButtonUI.viewRect.width - closeIcon.getIconWidth() : SearchButtonUI.viewRect.width;
            SearchButtonUI.displayRect.height = SearchButtonUI.viewRect.height = b.getHeight() - (i.bottom + SearchButtonUI.viewRect.y);
            SearchButtonUI.textRect.height = 0;
            SearchButtonUI.textRect.width = 0;
            SearchButtonUI.textRect.y = 0;
            SearchButtonUI.textRect.x = 0;
            SearchButtonUI.iconRect.height = 0;
            SearchButtonUI.iconRect.width = 0;
            SearchButtonUI.iconRect.y = 0;
            SearchButtonUI.iconRect.x = 0;
            Font f = c.getFont();
            g.setFont(f);
            String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), displayRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
            this.clearTextShiftOffset();
            if (model.isArmed() && model.isPressed()) {
                this.paintButtonPressed(g, b);
            }
            if (b.isSelected()) {
                this.paintCloseIcon(g, b);
            }
            if (b.getIcon() != null) {
                this.paintIcon(g, c, iconRect);
            }
            if (text != null && !text.equals("")) {
                View v = (View)c.getClientProperty("html");
                if (v != null) {
                    v.paint(g, textRect);
                } else {
                    this.paintText(g, b, textRect, text);
                }
            }
            if (b.isFocusPainted() && b.hasFocus()) {
                this.paintFocus(g, b, viewRect, textRect, iconRect);
            }
        }

        private void paintCloseIcon(Graphics g, AbstractButton b) {
            ButtonModel model = b.getModel();
            int x = b.getWidth() - b.getInsets().right - closeIcon.getIconWidth();
            int y = b.getHeight() / 2 - closeIcon.getIconHeight() / 2;
            if (model.isPressed() && model.isArmed()) {
                closeIcon.paintIcon(b, g, x + this.getTextShiftOffset(), y + this.getTextShiftOffset());
            } else {
                closeIcon.paintIcon(b, g, x, y);
            }
        }

        @Override
        protected BasicButtonListener createButtonListener(AbstractButton b) {
            return new CloseButtonListener(b);
        }

        public static class CloseButtonListener
        extends BasicButtonListener {
            private SearchButton btn;

            public CloseButtonListener(AbstractButton b) {
                super(b);
                this.btn = (SearchButton)b;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    AbstractButton b = (AbstractButton)e.getSource();
                    if (b.isSelected()) {
                        int y;
                        int w = closeIcon.getIconWidth();
                        int h = closeIcon.getIconHeight();
                        int x = b.getWidth() - b.getInsets().right - w;
                        Rectangle rec = new Rectangle(x, y = b.getHeight() / 2 - h / 2, w, h);
                        if (rec.contains(e.getX(), e.getY())) {
                            this.btn.searchTab.closeSearch(this.btn.search);
                        } else {
                            super.mouseReleased(e);
                        }
                    } else {
                        super.mouseReleased(e);
                    }
                }
            }
        }
    }
}

