/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.network;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.log.NLogger;
import phex.connection.OutgoingConnectionDispatcher;
import phex.gui.tabs.network.FavoritesListModel;
import phex.gui.tabs.network.FavoritesListRenderer;
import phex.host.FavoriteHost;
import phex.host.FavoritesContainer;
import phex.net.repres.PresentationManager;
import phex.servent.Servent;
import phex.utils.Localizer;

public class NetFavoritesPanel
extends JPanel {
    private final FavoritesContainer favoritesContainer;
    private JTextField newFavoriteHostTF;
    private JButton addToFavoritesHostBtn;
    private JList favoritesList;
    private JButton removeFromFavoritesHostBtn;
    private JButton connectToFavoritesHostBtn;

    public NetFavoritesPanel(FavoritesContainer favoritesContainer) {
        this.favoritesContainer = favoritesContainer;
        this.init();
    }

    private void init() {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("8dlu, d, 2dlu, d, 8dlu", "p, 3dlu, p, 4dlu, p, 2dlu, p, 2dlu, p:grow");
        PanelBuilder favoritesBuilder = new PanelBuilder(layout, this);
        favoritesBuilder.addSeparator(Localizer.getString("NetworkTab_Favorites"), cc.xywh(1, 1, 5, 1));
        this.newFavoriteHostTF = new JTextField(20);
        favoritesBuilder.add((Component)this.newFavoriteHostTF, cc.xy(2, 3));
        this.addToFavoritesHostBtn = new JButton(Localizer.getString("Add"));
        this.addToFavoritesHostBtn.addActionListener(new AddToFavoritesHostAction());
        favoritesBuilder.add((Component)this.addToFavoritesHostBtn, cc.xy(4, 3));
        this.favoritesList = new JList(new FavoritesListModel(this.favoritesContainer));
        this.favoritesList.setPrototypeCellValue("123.123.123.123:12345");
        this.favoritesList.setVisibleRowCount(5);
        this.favoritesList.setCellRenderer(new FavoritesListRenderer());
        favoritesBuilder.add((Component)new JScrollPane(this.favoritesList), cc.xywh(2, 5, 1, 5));
        this.connectToFavoritesHostBtn = new JButton(Localizer.getString("Connect"));
        this.connectToFavoritesHostBtn.addActionListener(new ConnectToFavoritesHostAction());
        favoritesBuilder.add((Component)this.connectToFavoritesHostBtn, cc.xy(4, 5));
        this.removeFromFavoritesHostBtn = new JButton(Localizer.getString("Remove"));
        this.removeFromFavoritesHostBtn.addActionListener(new RemoveFromFavoritesHostAction());
        favoritesBuilder.add((Component)this.removeFromFavoritesHostBtn, cc.xy(4, 7));
    }

    private final class AddToFavoritesHostAction
    implements ActionListener {
        private AddToFavoritesHostAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String host = NetFavoritesPanel.this.newFavoriteHostTF.getText();
                host = host.trim();
                if (host.length() > 0) {
                    try {
                        DestAddress address = PresentationManager.getInstance().createHostAddress(host, 6346);
                        NetFavoritesPanel.this.favoritesContainer.addFavorite(address);
                        NetFavoritesPanel.this.newFavoriteHostTF.setText("");
                    }
                    catch (MalformedDestAddressException malformedDestAddressException) {}
                }
            }
            catch (Exception exp) {
                NLogger.error(NetFavoritesPanel.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    private final class ConnectToFavoritesHostAction
    implements ActionListener {
        private ConnectToFavoritesHostAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FavoriteHost host = (FavoriteHost)NetFavoritesPanel.this.favoritesList.getSelectedValue();
                if (host == null) {
                    return;
                }
                OutgoingConnectionDispatcher.dispatchConnectToHost(host.getHostAddress(), Servent.getInstance().getHostService().getNetworkHostsContainer());
            }
            catch (Exception exp) {
                NLogger.error(NetFavoritesPanel.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    private final class RemoveFromFavoritesHostAction
    implements ActionListener {
        private RemoveFromFavoritesHostAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FavoriteHost host = (FavoriteHost)NetFavoritesPanel.this.favoritesList.getSelectedValue();
                NetFavoritesPanel.this.favoritesContainer.removeBookmarkedHost(host);
            }
            catch (Exception exp) {
                NLogger.error(NetFavoritesPanel.class, (Object)exp, (Throwable)exp);
            }
        }
    }
}

